/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.converter.valuestring;

import io.agrest.converter.valuestring.ISOLocalDateTimeConverter;
import io.agrest.converter.valuestring.ValueStringConverter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ISOLocalDateTimeConverterTest {
    private ValueStringConverter converter = ISOLocalDateTimeConverter.converter();

    @Test
    public void testISOLocalDateTimeConverter() {
        this._testISOLocalDateTimeConverter(1458995247000L, "yyyy-MM-dd'T'HH:mm:ss");
    }

    @Test
    public void testISOLocalDateTimeConverter_FractionalPart1() {
        this._testISOLocalDateTimeConverter(1458995247001L, "yyyy-MM-dd'T'HH:mm:ss.SSS");
    }

    @Test
    public void testISOLocalDateTimeConverter_FractionalPart2() {
        this._testISOLocalDateTimeConverter(1458995247100L, "yyyy-MM-dd'T'HH:mm:ss.S");
    }

    private void _testISOLocalDateTimeConverter(long millis, String expectedPattern) {
        LocalDateTime dateTime = ISOLocalDateTimeConverterTest.fromMillis(millis);
        String expected = DateTimeFormatter.ofPattern(expectedPattern).format(dateTime);
        Assertions.assertEquals((Object)expected, (Object)this.converter.asString((Object)dateTime));
    }

    private static LocalDateTime fromMillis(long millis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
    }
}

