/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.converter.valuestring;

import io.agrest.converter.valuestring.ISOLocalTimeConverter;
import io.agrest.converter.valuestring.ValueStringConverter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ISOLocalTimeConverterTest {
    private ValueStringConverter converter = ISOLocalTimeConverter.converter();

    @Test
    public void testISOLocalTimeConverter() {
        this._testISOLocalTimeConverter(1458995247000L, "HH:mm:ss");
    }

    @Test
    public void testISOLocalTimeConverter_FractionalPart1() {
        this._testISOLocalTimeConverter(1458995247001L, "HH:mm:ss.SSS");
    }

    @Test
    public void testISOLocalTimeConverter_FractionalPart2() {
        this._testISOLocalTimeConverter(1458995247100L, "HH:mm:ss.S");
    }

    private void _testISOLocalTimeConverter(long millis, String expectedPattern) {
        LocalTime time = ISOLocalTimeConverterTest.fromMillis(millis);
        String expected = DateTimeFormatter.ofPattern(expectedPattern).format(time);
        Assertions.assertEquals((Object)expected, (Object)this.converter.asString((Object)time));
    }

    private static LocalTime fromMillis(long millis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault()).toLocalTime();
    }
}

