/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.converter.valuestring;

import io.agrest.converter.valuestring.ISOOffsetDateTimeConverter;
import io.agrest.converter.valuestring.ValueStringConverter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ISOOffsetDateTimeConverterTest {
    private ValueStringConverter converter = ISOOffsetDateTimeConverter.converter();

    @Test
    public void testISOOffsetDateTimeConverter() {
        this._testISOOffsetDateTimeConverter(1458995247000L);
    }

    @Test
    public void testISOOffsetDateTimeConverter_FractionalPart1() {
        this._testISOOffsetDateTimeConverter(1458995247001L);
    }

    @Test
    public void testISOOffsetDateTimeConverter_FractionalPart2() {
        this._testISOOffsetDateTimeConverter(1458995247100L);
    }

    private void _testISOOffsetDateTimeConverter(long millis) {
        OffsetDateTime dateTime = ISOOffsetDateTimeConverterTest.fromMillis(millis);
        String expected = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(dateTime);
        Assertions.assertEquals((Object)expected, (Object)this.converter.asString((Object)dateTime));
    }

    private static OffsetDateTime fromMillis(long millis) {
        return OffsetDateTime.of(LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault()), ZoneOffset.ofHours(3));
    }
}

