/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.converter.valuestring;

import io.agrest.converter.valuestring.ISOTimeConverter;
import io.agrest.converter.valuestring.ValueStringConverter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ISOTimeConverterTest {
    private ValueStringConverter converter = ISOTimeConverter.converter();

    @Test
    public void testISOTimeConverter() {
        this._testISOTimeConverter(1458995247000L, "HH:mm:ss");
    }

    @Test
    public void testISOTimeConverter_FractionalPart1() {
        this._testISOTimeConverter(1458995247001L, "HH:mm:ss.SSS");
    }

    @Test
    public void testISOTimeConverter_FractionalPart2() {
        this._testISOTimeConverter(1458995247100L, "HH:mm:ss.S");
    }

    private void _testISOTimeConverter(long millis, String expectedPattern) {
        String expected = DateTimeFormatter.ofPattern(expectedPattern).format(ISOTimeConverterTest.fromMillis(millis));
        Assertions.assertEquals((Object)expected, (Object)this.converter.asString((Object)new Date(millis)));
    }

    private static LocalTime fromMillis(long millis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault()).toLocalTime();
    }
}

