/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.exp.parser;

import io.agrest.exp.parser.AgExpressionParser;
import io.agrest.exp.parser.AgExpressionParserVisitor;
import io.agrest.exp.parser.ExpRoot;
import io.agrest.exp.parser.ExpTestVisitor;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class AbstractExpTest {
    private ExpTestVisitor visitor;

    @BeforeAll
    void init() {
        this.visitor = this.provideVisitor();
    }

    abstract ExpTestVisitor provideVisitor();

    abstract Stream<String> parseExp();

    abstract Stream<Arguments> parseExpThrows();

    @ParameterizedTest
    @MethodSource
    @Order(value=1)
    void parseExp(String expString) {
        this.parseExpString(expString);
    }

    private void parseExpString(String expString) {
        ExpRoot expression = AgExpressionParser.parse((String)expString);
        Assertions.assertNotNull((Object)expression);
        Assertions.assertEquals(this.visitor.getNodeType(), (Object)expression.accept((AgExpressionParserVisitor)this.visitor, null));
    }

    @ParameterizedTest
    @MethodSource
    @Order(value=2)
    void parseExpThrows(String expString, Class<? extends Throwable> throwableType) {
        Assertions.assertThrows(throwableType, () -> this.parseExpString(expString));
    }
}

