/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.exp.parser;

import io.agrest.exp.parser.AgExpressionParser;
import io.agrest.exp.parser.ExpAbs;
import io.agrest.exp.parser.ExpAdd;
import io.agrest.exp.parser.ExpAnd;
import io.agrest.exp.parser.ExpBitwiseAnd;
import io.agrest.exp.parser.ExpBitwiseLeftShift;
import io.agrest.exp.parser.ExpBitwiseOr;
import io.agrest.exp.parser.ExpBitwiseXor;
import io.agrest.exp.parser.ExpBuilder;
import io.agrest.exp.parser.ExpDivide;
import io.agrest.exp.parser.ExpGreater;
import io.agrest.exp.parser.ExpLike;
import io.agrest.exp.parser.ExpMultiply;
import io.agrest.exp.parser.ExpObjPath;
import io.agrest.exp.parser.ExpOr;
import io.agrest.exp.parser.ExpRoot;
import io.agrest.exp.parser.ExpScalarInt;
import io.agrest.exp.parser.ExpScalarString;
import io.agrest.exp.parser.Node;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class CompositeExpTest {
    CompositeExpTest() {
    }

    static Stream<Arguments> parseExp() {
        return Stream.of(Arguments.of((Object[])new Object[]{"abs(1 + 2)", ExpBuilder.expFromType(ExpRoot.class).withValue("abs(1 + 2)").addChild(ExpBuilder.expFromType(ExpAbs.class).addChild(ExpBuilder.expFromType(ExpAdd.class).addChild(ExpBuilder.expFromType(ExpScalarInt.class).withValue(1)).addChild(ExpBuilder.expFromType(ExpScalarInt.class).withValue(2)))).build()}), Arguments.of((Object[])new Object[]{"a * b + c", ExpBuilder.expFromType(ExpRoot.class).withValue("a * b + c").addChild(ExpBuilder.expFromType(ExpAdd.class).addChild(ExpBuilder.expFromType(ExpMultiply.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("a")).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("b"))).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("c"))).build()}), Arguments.of((Object[])new Object[]{"a * (b + c)", ExpBuilder.expFromType(ExpRoot.class).withValue("a * (b + c)").addChild(ExpBuilder.expFromType(ExpMultiply.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("a")).addChild(ExpBuilder.expFromType(ExpAdd.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("b")).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("c")))).build()}), Arguments.of((Object[])new Object[]{"a / b + c", ExpBuilder.expFromType(ExpRoot.class).withValue("a / b + c").addChild(ExpBuilder.expFromType(ExpAdd.class).addChild(ExpBuilder.expFromType(ExpDivide.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("a")).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("b"))).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("c"))).build()}), Arguments.of((Object[])new Object[]{"a / (b + c)", ExpBuilder.expFromType(ExpRoot.class).withValue("a / (b + c)").addChild(ExpBuilder.expFromType(ExpDivide.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("a")).addChild(ExpBuilder.expFromType(ExpAdd.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("b")).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("c")))).build()}), Arguments.of((Object[])new Object[]{"a & b | c", ExpBuilder.expFromType(ExpRoot.class).withValue("a & b | c").addChild(ExpBuilder.expFromType(ExpBitwiseOr.class).addChild(ExpBuilder.expFromType(ExpBitwiseAnd.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("a")).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("b"))).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("c"))).build()}), Arguments.of((Object[])new Object[]{"a & (b | c)", ExpBuilder.expFromType(ExpRoot.class).withValue("a & (b | c)").addChild(ExpBuilder.expFromType(ExpBitwiseAnd.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("a")).addChild(ExpBuilder.expFromType(ExpBitwiseOr.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("b")).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("c")))).build()}), Arguments.of((Object[])new Object[]{"a & b ^ c", ExpBuilder.expFromType(ExpRoot.class).withValue("a & b ^ c").addChild(ExpBuilder.expFromType(ExpBitwiseXor.class).addChild(ExpBuilder.expFromType(ExpBitwiseAnd.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("a")).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("b"))).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("c"))).build()}), Arguments.of((Object[])new Object[]{"a & (b ^ c)", ExpBuilder.expFromType(ExpRoot.class).withValue("a | (b ^ c)").addChild(ExpBuilder.expFromType(ExpBitwiseAnd.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("a")).addChild(ExpBuilder.expFromType(ExpBitwiseXor.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("b")).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("c")))).build()}), Arguments.of((Object[])new Object[]{"a << b & c", ExpBuilder.expFromType(ExpRoot.class).withValue("a << b & c").addChild(ExpBuilder.expFromType(ExpBitwiseAnd.class).addChild(ExpBuilder.expFromType(ExpBitwiseLeftShift.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("a")).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("b"))).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("c"))).build()}), Arguments.of((Object[])new Object[]{"a << (b & c)", ExpBuilder.expFromType(ExpRoot.class).withValue("a << (b & c)").addChild(ExpBuilder.expFromType(ExpBitwiseLeftShift.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("a")).addChild(ExpBuilder.expFromType(ExpBitwiseAnd.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("b")).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("c")))).build()}), Arguments.of((Object[])new Object[]{"a and b or c", ExpBuilder.expFromType(ExpRoot.class).withValue("a and b or c").addChild(ExpBuilder.expFromType(ExpOr.class).addChild(ExpBuilder.expFromType(ExpAnd.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("a")).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("b"))).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("c"))).build()}), Arguments.of((Object[])new Object[]{"a and (b or c)", ExpBuilder.expFromType(ExpRoot.class).withValue("a and (b or c)").addChild(ExpBuilder.expFromType(ExpAnd.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("a")).addChild(ExpBuilder.expFromType(ExpOr.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("b")).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("c")))).build()}), Arguments.of((Object[])new Object[]{"t.amount > 0 and t.name like '%story'", ExpBuilder.expFromType(ExpRoot.class).withValue("t.amount > 0 and t.name like '%story'").addChild(ExpBuilder.expFromType(ExpAnd.class).addChild(ExpBuilder.expFromType(ExpGreater.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("t.amount")).addChild(ExpBuilder.expFromType(ExpScalarInt.class).withValue(0))).addChild(ExpBuilder.expFromType(ExpLike.class).addChild(ExpBuilder.expFromType(ExpObjPath.class).withValue("t.name")).addChild(ExpBuilder.expFromType(ExpScalarString.class).withValue("%story")))).build()}));
    }

    private static String stringify(Node exp) {
        ArrayList<CallSite> properties = new ArrayList<CallSite>(List.of("id=" + exp.getId(), "value=" + exp.jjtGetValue(), "parent=" + exp.jjtGetParent(), "children=" + IntStream.range(0, exp.jjtGetNumChildren()).mapToObj(arg_0 -> ((Node)exp).jjtGetChild(arg_0)).map(CompositeExpTest::stringify).collect(Collectors.joining(", ", "[", "]"))));
        if (exp.getClass() == ExpRoot.class) {
            ExpRoot expRoot = (ExpRoot)exp;
            properties.add(2, (CallSite)((Object)("positionalParams=" + Arrays.toString(expRoot.getPositionalParams()))));
            properties.add(3, (CallSite)((Object)("namedParams=" + expRoot.getNamedParams().toString())));
        }
        return exp + properties.stream().collect(Collectors.joining(", ", "{", "}"));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource
    void parseExp(String expString, ExpRoot expected) {
        ExpRoot exp = AgExpressionParser.parse((String)expString);
        Assertions.assertEquals((Object)expected, (Object)exp, () -> String.format("%nExpected: %s%nActual: %s%n", CompositeExpTest.stringify((Node)expected), CompositeExpTest.stringify((Node)exp)));
    }
}

