/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.exp.parser;

import io.agrest.exp.parser.ExpAbs;
import io.agrest.exp.parser.ExpAdd;
import io.agrest.exp.parser.ExpAnd;
import io.agrest.exp.parser.ExpBetween;
import io.agrest.exp.parser.ExpBitwiseAnd;
import io.agrest.exp.parser.ExpBitwiseLeftShift;
import io.agrest.exp.parser.ExpBitwiseNot;
import io.agrest.exp.parser.ExpBitwiseOr;
import io.agrest.exp.parser.ExpBitwiseRightShift;
import io.agrest.exp.parser.ExpBitwiseXor;
import io.agrest.exp.parser.ExpConcat;
import io.agrest.exp.parser.ExpCurrentDate;
import io.agrest.exp.parser.ExpCurrentTime;
import io.agrest.exp.parser.ExpCurrentTimestamp;
import io.agrest.exp.parser.ExpDivide;
import io.agrest.exp.parser.ExpEqual;
import io.agrest.exp.parser.ExpExtract;
import io.agrest.exp.parser.ExpFalse;
import io.agrest.exp.parser.ExpGreater;
import io.agrest.exp.parser.ExpGreaterOrEqual;
import io.agrest.exp.parser.ExpIn;
import io.agrest.exp.parser.ExpLength;
import io.agrest.exp.parser.ExpLess;
import io.agrest.exp.parser.ExpLessOrEqual;
import io.agrest.exp.parser.ExpLike;
import io.agrest.exp.parser.ExpLikeIgnoreCase;
import io.agrest.exp.parser.ExpLocate;
import io.agrest.exp.parser.ExpLower;
import io.agrest.exp.parser.ExpMod;
import io.agrest.exp.parser.ExpMultiply;
import io.agrest.exp.parser.ExpNamedParameter;
import io.agrest.exp.parser.ExpNegate;
import io.agrest.exp.parser.ExpNot;
import io.agrest.exp.parser.ExpNotBetween;
import io.agrest.exp.parser.ExpNotEqual;
import io.agrest.exp.parser.ExpNotIn;
import io.agrest.exp.parser.ExpNotLike;
import io.agrest.exp.parser.ExpNotLikeIgnoreCase;
import io.agrest.exp.parser.ExpObjPath;
import io.agrest.exp.parser.ExpOr;
import io.agrest.exp.parser.ExpRoot;
import io.agrest.exp.parser.ExpScalarBool;
import io.agrest.exp.parser.ExpScalarFloat;
import io.agrest.exp.parser.ExpScalarInt;
import io.agrest.exp.parser.ExpScalarList;
import io.agrest.exp.parser.ExpScalarNull;
import io.agrest.exp.parser.ExpScalarString;
import io.agrest.exp.parser.ExpSqrt;
import io.agrest.exp.parser.ExpSubstring;
import io.agrest.exp.parser.ExpSubtract;
import io.agrest.exp.parser.ExpTrim;
import io.agrest.exp.parser.ExpTrue;
import io.agrest.exp.parser.ExpUpper;
import io.agrest.exp.parser.SimpleNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExpBuilder {
    private static final Map<Class<? extends SimpleNode>, Integer> expIdMap = new HashMap<Class<? extends SimpleNode>, Integer>();
    private final SimpleNode exp;
    private final List<ExpBuilder> children = new ArrayList<ExpBuilder>();
    private Object value;
    private Object[] positionalParams;
    private Map<String, Object> namedParams;
    private SimpleNode parent;

    public ExpBuilder(Class<? extends SimpleNode> expType) {
        try {
            this.exp = expType.getConstructor(Integer.TYPE).newInstance(expIdMap.get(expType));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ExpBuilder expFromType(Class<? extends SimpleNode> expType) {
        return new ExpBuilder(expType);
    }

    public ExpBuilder withPositionalParams(Object ... params) {
        this.positionalParams = params;
        return this;
    }

    public ExpBuilder withNamedParams(Map<String, Object> params) {
        this.namedParams = params;
        return this;
    }

    public ExpBuilder withValue(Object value) {
        this.value = value;
        return this;
    }

    public ExpBuilder addChild(ExpBuilder childBuilder) {
        this.children.add(childBuilder);
        childBuilder.parent = this.exp;
        return this;
    }

    public SimpleNode build() {
        SimpleNode[] children;
        if (this.exp.getClass() == ExpRoot.class) {
            ExpRoot expRoot = (ExpRoot)this.exp;
            expRoot.positionalParams(this.positionalParams);
            expRoot.namedParams(this.namedParams);
        }
        if ((children = (SimpleNode[])this.children.stream().map(ExpBuilder::build).toArray(SimpleNode[]::new)).length != 0) {
            this.exp.children = children;
        }
        this.exp.parent = this.parent;
        this.exp.value = this.value;
        return this.exp;
    }

    static {
        expIdMap.put(ExpRoot.class, 0);
        expIdMap.put(ExpOr.class, 2);
        expIdMap.put(ExpAnd.class, 3);
        expIdMap.put(ExpNot.class, 4);
        expIdMap.put(ExpTrue.class, 5);
        expIdMap.put(ExpFalse.class, 6);
        expIdMap.put(ExpEqual.class, 7);
        expIdMap.put(ExpNotEqual.class, 8);
        expIdMap.put(ExpLessOrEqual.class, 9);
        expIdMap.put(ExpLess.class, 10);
        expIdMap.put(ExpGreater.class, 11);
        expIdMap.put(ExpGreaterOrEqual.class, 12);
        expIdMap.put(ExpLike.class, 13);
        expIdMap.put(ExpLikeIgnoreCase.class, 14);
        expIdMap.put(ExpIn.class, 15);
        expIdMap.put(ExpBetween.class, 16);
        expIdMap.put(ExpNotLike.class, 17);
        expIdMap.put(ExpNotLikeIgnoreCase.class, 18);
        expIdMap.put(ExpNotIn.class, 19);
        expIdMap.put(ExpNotBetween.class, 20);
        expIdMap.put(ExpScalarList.class, 21);
        expIdMap.put(ExpScalarNull.class, 22);
        expIdMap.put(ExpScalarString.class, 23);
        expIdMap.put(ExpScalarBool.class, 24);
        expIdMap.put(ExpBitwiseOr.class, 25);
        expIdMap.put(ExpBitwiseXor.class, 26);
        expIdMap.put(ExpBitwiseAnd.class, 27);
        expIdMap.put(ExpBitwiseLeftShift.class, 28);
        expIdMap.put(ExpBitwiseRightShift.class, 29);
        expIdMap.put(ExpAdd.class, 30);
        expIdMap.put(ExpSubtract.class, 31);
        expIdMap.put(ExpMultiply.class, 32);
        expIdMap.put(ExpDivide.class, 33);
        expIdMap.put(ExpBitwiseNot.class, 34);
        expIdMap.put(ExpNegate.class, 35);
        expIdMap.put(ExpScalarInt.class, 36);
        expIdMap.put(ExpScalarFloat.class, 37);
        expIdMap.put(ExpConcat.class, 38);
        expIdMap.put(ExpSubstring.class, 39);
        expIdMap.put(ExpTrim.class, 40);
        expIdMap.put(ExpLower.class, 41);
        expIdMap.put(ExpUpper.class, 42);
        expIdMap.put(ExpLength.class, 43);
        expIdMap.put(ExpLocate.class, 44);
        expIdMap.put(ExpAbs.class, 45);
        expIdMap.put(ExpSqrt.class, 46);
        expIdMap.put(ExpMod.class, 47);
        expIdMap.put(ExpCurrentDate.class, 48);
        expIdMap.put(ExpCurrentTime.class, 49);
        expIdMap.put(ExpCurrentTimestamp.class, 50);
        expIdMap.put(ExpExtract.class, 51);
        expIdMap.put(ExpNamedParameter.class, 52);
        expIdMap.put(ExpObjPath.class, 53);
    }
}

