/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.meta;

import io.agrest.AgRequestBuilder;
import io.agrest.EntityUpdate;
import io.agrest.RootResourceEntity;
import io.agrest.access.CreateAuthorizer;
import io.agrest.access.DeleteAuthorizer;
import io.agrest.access.PathChecker;
import io.agrest.access.ReadFilter;
import io.agrest.access.UpdateAuthorizer;
import io.agrest.meta.AgAttribute;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgEntityOverlay;
import io.agrest.meta.AgIdPart;
import io.agrest.meta.AgSchema;
import io.agrest.meta.DefaultAttribute;
import io.agrest.meta.DefaultEntity;
import io.agrest.meta.DefaultIdPart;
import io.agrest.pojo.model.P1;
import io.agrest.reader.DataReader;
import io.agrest.resolver.RootDataResolver;
import io.agrest.runtime.processor.select.SelectContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.cayenne.di.Injector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class AgEntityOverlayTest {
    @Test
    public void testResolve_attribute() {
        RootDataResolver r1 = (RootDataResolver)Mockito.mock(RootDataResolver.class);
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), r1, ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay attributeOverlay = AgEntity.overlay(P1.class).attribute("a1", String.class, P1::getName);
        AgEntity eo = attributeOverlay.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities());
        Assertions.assertEquals((Object)"p1", (Object)eo.getName());
        Assertions.assertEquals(P1.class, (Object)eo.getType());
        Assertions.assertEquals((Object)r1, (Object)eo.getDataResolver());
        Assertions.assertEquals((int)1, (int)eo.getAttributes().size());
    }

    @Test
    public void testResolve_attribute_throwingFunction() {
        RootDataResolver r1 = (RootDataResolver)Mockito.mock(RootDataResolver.class);
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), r1, ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
        Function<P1, String> throwing = p1 -> {
            throw new RuntimeException("testing this exception");
        };
        AgEntityOverlay attributeOverlay = AgEntity.overlay(P1.class).attribute("a1", String.class, throwing);
        AgEntity eo = attributeOverlay.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities());
        DataReader reader = eo.getAttribute("a1").getDataReader();
        Assertions.assertThrows(RuntimeException.class, () -> reader.read((Object)new P1()));
    }

    @Test
    public void testResolve_RootResolver() {
        RootDataResolver r1 = (RootDataResolver)Mockito.mock(RootDataResolver.class);
        RootDataResolver r2 = (RootDataResolver)Mockito.mock(RootDataResolver.class);
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), r1, ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay resolverOnly = AgEntity.overlay(P1.class).dataResolver(r2);
        AgEntity eo = resolverOnly.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities());
        Assertions.assertEquals((Object)"p1", (Object)eo.getName());
        Assertions.assertEquals(P1.class, (Object)eo.getType());
        Assertions.assertEquals((Object)r2, (Object)eo.getDataResolver());
    }

    @Test
    public void testResolve_RootResolverFunction() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
        List<P1> p1s = Arrays.asList(new P1(), new P1());
        AgEntityOverlay resolverOnly = AgEntity.overlay(P1.class).dataResolver(c -> p1s);
        AgEntity eo = resolverOnly.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities());
        SelectContext context = new SelectContext(P1.class, (AgRequestBuilder)Mockito.mock(AgRequestBuilder.class), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        context.setEntity(new RootResourceEntity(eo));
        eo.getDataResolver().fetchData(context);
        Assertions.assertSame(p1s, (Object)context.getEntity().getData());
    }

    @Test
    public void testResolve_readFilter() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay o = AgEntity.overlay(P1.class).readFilter(p1 -> p1.getName().startsWith("a"));
        ReadFilter f = o.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getReadFilter();
        P1 p11 = new P1();
        p11.setName("x");
        P1 p12 = new P1();
        p12.setName("a");
        Assertions.assertFalse((boolean)f.isAllowed((Object)p11));
        Assertions.assertTrue((boolean)f.isAllowed((Object)p12));
    }

    @Test
    public void testResolve_readFilter_Additivity() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), p1 -> p1.getName().startsWith("a"), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay o = AgEntity.overlay(P1.class).readFilter(p1 -> p1.getName().endsWith("a"));
        ReadFilter f = o.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getReadFilter();
        P1 p11 = new P1();
        p11.setName("ax");
        P1 p12 = new P1();
        p12.setName("xa");
        P1 p13 = new P1();
        p13.setName("axa");
        Assertions.assertFalse((boolean)f.isAllowed((Object)p11));
        Assertions.assertFalse((boolean)f.isAllowed((Object)p12));
        Assertions.assertTrue((boolean)f.isAllowed((Object)p13));
    }

    @Test
    public void testResolve_readFilter_IgnoreOverlaid() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), p1 -> p1.getName().startsWith("a"), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay o = AgEntity.overlay(P1.class).ignoreOverlaidReadFilter().readFilter(p1 -> p1.getName().endsWith("a"));
        ReadFilter f = o.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getReadFilter();
        P1 p11 = new P1();
        p11.setName("ax");
        P1 p12 = new P1();
        p12.setName("xa");
        P1 p13 = new P1();
        p13.setName("axa");
        Assertions.assertFalse((boolean)f.isAllowed((Object)p11));
        Assertions.assertTrue((boolean)f.isAllowed((Object)p12));
        Assertions.assertTrue((boolean)f.isAllowed((Object)p13));
    }

    @Test
    public void testResolve_readFilter_IgnoreOverlaid_NoOverlayFilter() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), p1 -> p1.getName().startsWith("a"), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay o = AgEntity.overlay(P1.class).ignoreOverlaidReadFilter();
        ReadFilter f = o.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getReadFilter();
        P1 p11 = new P1();
        p11.setName("ax");
        P1 p12 = new P1();
        p12.setName("xa");
        P1 p13 = new P1();
        p13.setName("axa");
        Assertions.assertTrue((boolean)f.isAllowed((Object)p11));
        Assertions.assertTrue((boolean)f.isAllowed((Object)p12));
        Assertions.assertTrue((boolean)f.isAllowed((Object)p13));
    }

    @Test
    public void testResolve_createAuthorizer() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay o = AgEntity.overlay(P1.class).createAuthorizer(u -> ((String)u.getValues().get("name")).startsWith("a"));
        CreateAuthorizer f = o.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getCreateAuthorizer();
        EntityUpdate p11 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p11.getValues().put("name", "x");
        EntityUpdate p12 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p12.getValues().put("name", "a");
        Assertions.assertFalse((boolean)f.isAllowed(p11));
        Assertions.assertTrue((boolean)f.isAllowed(p12));
    }

    @Test
    public void testResolve_createAuthorizer_Additivity() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), u -> ((String)u.getValues().get("name")).startsWith("a"), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay o = AgEntity.overlay(P1.class).createAuthorizer(u -> ((String)u.getValues().get("name")).endsWith("a"));
        CreateAuthorizer f = o.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getCreateAuthorizer();
        EntityUpdate p11 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p11.getValues().put("name", "ax");
        EntityUpdate p12 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p12.getValues().put("name", "xa");
        EntityUpdate p13 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p13.getValues().put("name", "axa");
        Assertions.assertFalse((boolean)f.isAllowed(p11));
        Assertions.assertFalse((boolean)f.isAllowed(p12));
        Assertions.assertTrue((boolean)f.isAllowed(p13));
    }

    @Test
    public void testResolve_createAuthorizer_IgnoreOverlaid() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), u -> ((String)u.getValues().get("name")).startsWith("a"), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay o = AgEntity.overlay(P1.class).createAuthorizer(u -> ((String)u.getValues().get("name")).endsWith("a")).ignoreOverlaidCreateAuthorizer();
        CreateAuthorizer f = o.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getCreateAuthorizer();
        EntityUpdate p11 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p11.getValues().put("name", "ax");
        EntityUpdate p12 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p12.getValues().put("name", "xa");
        EntityUpdate p13 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p13.getValues().put("name", "axa");
        Assertions.assertFalse((boolean)f.isAllowed(p11));
        Assertions.assertTrue((boolean)f.isAllowed(p12));
        Assertions.assertTrue((boolean)f.isAllowed(p13));
    }

    @Test
    public void testResolve_updateAuthorizer() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay o = AgEntity.overlay(P1.class).updateAuthorizer((p1, u) -> ((String)u.getValues().get("name")).startsWith("a"));
        UpdateAuthorizer f = o.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getUpdateAuthorizer();
        EntityUpdate p11 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p11.getValues().put("name", "x");
        EntityUpdate p12 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p12.getValues().put("name", "a");
        Assertions.assertFalse((boolean)f.isAllowed((Object)((P1)Mockito.mock(P1.class)), p11));
        Assertions.assertTrue((boolean)f.isAllowed((Object)((P1)Mockito.mock(P1.class)), p12));
    }

    @Test
    public void testResolve_updateAuthorizer_Additivity() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), (p1, u) -> ((String)u.getValues().get("name")).startsWith("a"), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay o = AgEntity.overlay(P1.class).updateAuthorizer((p1, u) -> ((String)u.getValues().get("name")).endsWith("a"));
        UpdateAuthorizer f = o.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getUpdateAuthorizer();
        EntityUpdate p11 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p11.getValues().put("name", "ax");
        EntityUpdate p12 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p12.getValues().put("name", "xa");
        EntityUpdate p13 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p13.getValues().put("name", "axa");
        Assertions.assertFalse((boolean)f.isAllowed((Object)((P1)Mockito.mock(P1.class)), p11));
        Assertions.assertFalse((boolean)f.isAllowed((Object)((P1)Mockito.mock(P1.class)), p12));
        Assertions.assertTrue((boolean)f.isAllowed((Object)((P1)Mockito.mock(P1.class)), p13));
    }

    @Test
    public void testResolve_updateAuthorizer_IgnoreOverlaid() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), (p1, u) -> ((String)u.getValues().get("name")).startsWith("a"), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay o = AgEntity.overlay(P1.class).ignoreOverlaidUpdateAuthorizer().updateAuthorizer((p1, u) -> ((String)u.getValues().get("name")).endsWith("a"));
        UpdateAuthorizer f = o.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getUpdateAuthorizer();
        EntityUpdate p11 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p11.getValues().put("name", "ax");
        EntityUpdate p12 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p12.getValues().put("name", "xa");
        EntityUpdate p13 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p13.getValues().put("name", "axa");
        Assertions.assertFalse((boolean)f.isAllowed((Object)((P1)Mockito.mock(P1.class)), p11));
        Assertions.assertTrue((boolean)f.isAllowed((Object)((P1)Mockito.mock(P1.class)), p12));
        Assertions.assertTrue((boolean)f.isAllowed((Object)((P1)Mockito.mock(P1.class)), p13));
    }

    @Test
    public void testMergeResolve_updateAuthorizer_IgnoreOverlaid() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), (p1, u) -> ((String)u.getValues().get("name")).startsWith("a"), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay o = AgEntity.overlay(P1.class).ignoreOverlaidUpdateAuthorizer().updateAuthorizer((p1, u) -> ((String)u.getValues().get("name")).endsWith("a"));
        AgEntityOverlay oMerged = AgEntity.overlay(P1.class).merge(o);
        UpdateAuthorizer f = oMerged.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getUpdateAuthorizer();
        EntityUpdate p11 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p11.getValues().put("name", "ax");
        EntityUpdate p12 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p12.getValues().put("name", "xa");
        EntityUpdate p13 = new EntityUpdate((AgEntity)Mockito.mock(AgEntity.class));
        p13.getValues().put("name", "axa");
        Assertions.assertFalse((boolean)f.isAllowed((Object)((P1)Mockito.mock(P1.class)), p11));
        Assertions.assertTrue((boolean)f.isAllowed((Object)((P1)Mockito.mock(P1.class)), p12));
        Assertions.assertTrue((boolean)f.isAllowed((Object)((P1)Mockito.mock(P1.class)), p13));
    }

    @Test
    public void testResolve_deleteAuthorizer() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay o = AgEntity.overlay(P1.class).deleteAuthorizer(p1 -> p1.getName().startsWith("a"));
        DeleteAuthorizer f = o.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getDeleteAuthorizer();
        P1 p11 = new P1();
        p11.setName("x");
        P1 p12 = new P1();
        p12.setName("a");
        Assertions.assertFalse((boolean)f.isAllowed((Object)p11));
        Assertions.assertTrue((boolean)f.isAllowed((Object)p12));
    }

    @Test
    public void testResolve_deleteAuthorizer_Additivity() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), p1 -> p1.getName().startsWith("a"));
        AgEntityOverlay o = AgEntity.overlay(P1.class).deleteAuthorizer(p1 -> p1.getName().endsWith("a"));
        DeleteAuthorizer f = o.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getDeleteAuthorizer();
        P1 p11 = new P1();
        p11.setName("ax");
        P1 p12 = new P1();
        p12.setName("xa");
        P1 p13 = new P1();
        p13.setName("axa");
        Assertions.assertFalse((boolean)f.isAllowed((Object)p11));
        Assertions.assertFalse((boolean)f.isAllowed((Object)p12));
        Assertions.assertTrue((boolean)f.isAllowed((Object)p13));
    }

    @Test
    public void testResolve_deleteAuthorizer_IgnoreOverlaid() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), p1 -> p1.getName().startsWith("a"));
        AgEntityOverlay o = AgEntity.overlay(P1.class).ignoreOverlaidDeleteAuthorizer().deleteAuthorizer(p1 -> p1.getName().endsWith("a"));
        DeleteAuthorizer f = o.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getDeleteAuthorizer();
        P1 p11 = new P1();
        p11.setName("ax");
        P1 p12 = new P1();
        p12.setName("xa");
        P1 p13 = new P1();
        p13.setName("axa");
        Assertions.assertFalse((boolean)f.isAllowed((Object)p11));
        Assertions.assertTrue((boolean)f.isAllowed((Object)p12));
        Assertions.assertTrue((boolean)f.isAllowed((Object)p13));
    }

    @Test
    public void testResolve_propFilter_MakeInaccessible() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of("name", new DefaultAttribute("name", String.class, true, true, o -> null)), Collections.emptyMap(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay o2 = AgEntity.overlay(P1.class).readablePropFilter(b -> b.property("name", false)).writablePropFilter(b -> b.property("name", false));
        AgAttribute a = o2.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getAttribute("name");
        Assertions.assertFalse((boolean)a.isReadable());
        Assertions.assertFalse((boolean)a.isWritable());
    }

    @Test
    public void testResolve_propFilter_MakeAccessible() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of(), Map.of("name", new DefaultAttribute("name", String.class, false, false, o -> null)), Collections.emptyMap(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay o2 = AgEntity.overlay(P1.class).readablePropFilter(b -> b.property("name", true)).writablePropFilter(b -> b.property("name", true));
        AgAttribute a = o2.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getAttribute("name");
        Assertions.assertTrue((boolean)a.isReadable());
        Assertions.assertTrue((boolean)a.isWritable());
    }

    @Test
    public void testResolve_propFilter_MakeIdInAccessible() {
        DefaultEntity e = new DefaultEntity("p1", P1.class, false, List.of(), Map.of("id1", new DefaultIdPart("id1", Integer.class, true, true, o -> "")), Collections.emptyMap(), Collections.emptyMap(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
        AgEntityOverlay o2 = AgEntity.overlay(P1.class).readablePropFilter(b -> b.id(false)).writablePropFilter(b -> b.id(false));
        Collection parts = o2.resolve((AgSchema)Mockito.mock(AgSchema.class), (AgEntity)e, e.getSubEntities()).getIdParts();
        Assertions.assertEquals((int)1, (int)parts.size());
        AgIdPart part = (AgIdPart)parts.iterator().next();
        Assertions.assertEquals((Object)"id1", (Object)part.getName());
        Assertions.assertFalse((boolean)part.isReadable());
        Assertions.assertFalse((boolean)part.isWritable());
    }
}

