/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.meta;

import io.agrest.access.CreateAuthorizer;
import io.agrest.access.DeleteAuthorizer;
import io.agrest.access.ReadFilter;
import io.agrest.access.UpdateAuthorizer;
import io.agrest.meta.AgAttribute;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgEntityOverlay;
import io.agrest.meta.AgSchema;
import io.agrest.meta.DefaultEntity;
import io.agrest.resolver.RootDataResolver;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class DefaultEntityTest {
    final AgSchema mockSchema = (AgSchema)Mockito.mock(AgSchema.class);
    final AgEntity<O111> e111 = new DefaultEntity("o111", O111.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
    final AgEntity<O11> e11 = new DefaultEntity("o11", O11.class, false, List.of(this.e111), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
    final AgEntity<O11> e12 = new DefaultEntity("o12", O12.class, false, List.of(), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());
    final AgEntity<O1> e1 = new DefaultEntity("o1", O1.class, false, List.of(this.e11, this.e12), Map.of(), Map.of(), Map.of(), (RootDataResolver)Mockito.mock(RootDataResolver.class), ReadFilter.allowsAllFilter(), CreateAuthorizer.allowsAllFilter(), UpdateAuthorizer.allowsAllFilter(), DeleteAuthorizer.allowsAllFilter());

    @Test
    public void testResolveOverlayHierarchy_NoSubclasses() {
        Assertions.assertSame(this.e111, (Object)this.e111.resolveOverlayHierarchy(this.mockSchema, Map.of()));
        Assertions.assertSame(this.e111, (Object)this.e111.resolveOverlayHierarchy(this.mockSchema, Map.of(O111.class, AgEntity.overlay(O111.class))));
        AgEntityOverlay o1 = AgEntity.overlay(O111.class).attribute("oa1", String.class, o -> "oa1");
        AgEntity oe1 = this.e111.resolveOverlayHierarchy(this.mockSchema, Map.of(O111.class, o1));
        Assertions.assertNotSame(this.e111, (Object)oe1);
        Assertions.assertEquals((Object)"oa1", (Object)oe1.getAttributes().stream().map(AgAttribute::getName).collect(Collectors.joining(",")));
    }

    @Test
    public void testResolveOverlayHierarchy_RootChanges() {
        Assertions.assertSame(this.e1, (Object)this.e1.resolveOverlayHierarchy(this.mockSchema, Map.of()));
        Assertions.assertSame(this.e1, (Object)this.e1.resolveOverlayHierarchy(this.mockSchema, Map.of(O1.class, AgEntity.overlay(O1.class))));
        AgEntityOverlay o1 = AgEntity.overlay(O1.class).attribute("oa1", String.class, o -> "oa1");
        AgEntity oe1 = this.e1.resolveOverlayHierarchy(this.mockSchema, Map.of(O1.class, o1));
        Assertions.assertNotSame(this.e1, (Object)oe1);
        Assertions.assertEquals((Object)"oa1", (Object)oe1.getAttributes().stream().map(AgAttribute::getName).collect(Collectors.joining(",")));
        Assertions.assertEquals((int)2, (int)oe1.getSubEntities().size());
        Assertions.assertEquals((Object)"o11,o12", (Object)oe1.getSubEntities().stream().map(AgEntity::getName).sorted().collect(Collectors.joining(",")));
        Assertions.assertFalse((boolean)oe1.getSubEntities().contains(this.e11), (String)"Child entity must have been overlaid with parent changes");
        Assertions.assertFalse((boolean)oe1.getSubEntities().contains(this.e12), (String)"Child entity must have been overlaid with parent changes");
    }

    @Test
    public void testResolveOverlayHierarchy_ChildChanges() {
        AgEntityOverlay o111 = AgEntity.overlay(O111.class).attribute("a111", String.class, o -> "a111");
        AgEntity oe1 = this.e1.resolveOverlayHierarchy(this.mockSchema, Map.of(O111.class, o111));
        Assertions.assertNotSame(this.e1, (Object)oe1);
        Assertions.assertEquals((int)2, (int)oe1.getSubEntities().size());
        Assertions.assertFalse((boolean)oe1.getSubEntities().contains(this.e11));
        Assertions.assertTrue((boolean)oe1.getSubEntities().contains(this.e12));
        AgEntity oe11 = oe1.getSubEntities().stream().filter(e -> "o11".equals(e.getName())).findFirst().get();
        Assertions.assertNotSame(this.e11, (Object)oe11);
        Assertions.assertEquals((int)1, (int)oe11.getSubEntities().size());
        AgEntity oe111 = oe11.getSubEntities().stream().filter(e -> "o111".equals(e.getName())).findFirst().get();
        Assertions.assertNotSame(this.e111, (Object)oe111);
        Assertions.assertEquals((Object)"a111", (Object)oe111.getAttributes().stream().map(AgAttribute::getName).collect(Collectors.joining(",")));
    }

    public static class O111
    extends O11 {
    }

    public static class O12
    extends O1 {
    }

    public static class O11
    extends O1 {
    }

    public static class O1 {
    }
}

