/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.meta;

import io.agrest.annotation.AgAttribute;
import io.agrest.annotation.AgId;
import io.agrest.annotation.AgRelationship;
import io.agrest.compiler.AnnotationsAgEntityCompiler;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgSchema;
import io.agrest.meta.LazySchema;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class LazySchemaTest {
    private static AgSchema schema;

    @BeforeAll
    public static void before() {
        AnnotationsAgEntityCompiler compiler = new AnnotationsAgEntityCompiler(Collections.emptyMap());
        schema = new LazySchema(List.of(compiler));
    }

    @Test
    public void testGetAgEntity_NoRelationships() {
        AgEntity tr = schema.getEntity(Tr.class);
        Assertions.assertNotNull((Object)tr);
        Assertions.assertEquals((Object)"Tr", (Object)tr.getName());
        Assertions.assertSame(Tr.class, (Object)tr.getType());
        Assertions.assertEquals((Object)"Tr", (Object)tr.getName());
        Assertions.assertNotNull((Object)tr.getAttribute("a"));
        Assertions.assertNotNull((Object)tr.getAttribute("b"));
        Assertions.assertEquals((int)0, (int)tr.getRelationships().size());
    }

    @Test
    public void testGetAgEntity_Relationships() {
        AgEntity ts = schema.getEntity(Ts.class);
        Assertions.assertNotNull((Object)ts);
        Assertions.assertEquals((Object)"Ts", (Object)ts.getName());
        Assertions.assertSame(Ts.class, (Object)ts.getType());
        Assertions.assertEquals((Object)"Ts", (Object)ts.getName());
        Assertions.assertNotNull((Object)ts.getAttribute("m"));
        Assertions.assertNotNull((Object)ts.getAttribute("n"));
        Assertions.assertNotNull((Object)ts.getRelationship("rtrs"));
        Assertions.assertEquals((int)1, (int)ts.getRelationships().size());
    }

    public static class Ts {
        @AgId
        public int getId() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getN() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getM() {
            throw new UnsupportedOperationException();
        }

        @AgRelationship
        public List<Tr> getRtrs() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Tr {
        @AgId
        public int getId() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public int getA() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getB() {
            throw new UnsupportedOperationException();
        }
    }
}

