/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.pojo.runtime;

import io.agrest.meta.AgAttribute;
import io.agrest.meta.AgEntity;
import io.agrest.pojo.runtime.PojoStore;
import io.agrest.processor.Processor;
import io.agrest.processor.ProcessorOutcome;
import io.agrest.protocol.Sort;
import io.agrest.reader.DataReader;
import io.agrest.runtime.processor.select.SelectContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.cayenne.di.Inject;
import org.junit.jupiter.api.Assertions;

public class PojoFetchStage
implements Processor<SelectContext<?>> {
    private final PojoStore db;

    public PojoFetchStage(@Inject PojoStore db) {
        this.db = db;
    }

    public ProcessorOutcome execute(SelectContext<?> context) {
        this.findObjects(context);
        return ProcessorOutcome.CONTINUE;
    }

    <T> void findObjects(SelectContext<T> context) {
        Map typeBucket = this.db.bucket(context.getType());
        if (context.isById()) {
            Map idMap = context.getId().asMap(context.getEntity().getAgEntity());
            Map id = idMap.size() > 1 ? idMap : idMap.values().iterator().next();
            Object object = typeBucket.get(id);
            context.getEntity().setData(object != null ? List.of(object) : List.of());
            return;
        }
        ArrayList list = new ArrayList(typeBucket.values());
        for (Sort s : context.getEntity().getOrderings()) {
            list.sort(this.toComparator(context.getEntity().getAgEntity(), s));
        }
        context.getEntity().setData(list);
    }

    private <T> Comparator<T> toComparator(AgEntity<T> entity, Sort s) {
        Function<Object, Comparable> keyReader;
        AgAttribute attribute = entity.getAttribute(s.getPath());
        if (attribute != null) {
            keyReader = t -> (Comparable)attribute.getDataReader().read(t);
        } else if ("id".equals(s.getPath())) {
            keyReader = t -> this.readId(t, entity.getIdReader());
        } else {
            throw new RuntimeException("Can't find sort property reader for '" + s.getPath() + "'");
        }
        return Comparator.comparing(keyReader);
    }

    private Comparable readId(Object object, DataReader idReader) {
        if (object == null) {
            return null;
        }
        Map id = (Map)idReader.read(object);
        Assertions.assertEquals((int)1, (int)id.size(), () -> "Unexpected id size " + id.size() + " for object " + object.getClass());
        return (Comparable)id.values().iterator().next();
    }
}

