/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.processor;

import io.agrest.processor.ProcessingContext;
import io.agrest.processor.Processor;
import io.agrest.processor.ProcessorOutcome;
import io.agrest.runtime.processor.select.SelectContext;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ProcessorTest {
    private Processor<SelectContext<?>> shouldContinue1;
    private Processor<SelectContext<?>> shouldContinue2;
    private Processor<SelectContext<?>> shouldStop;
    private SelectContext<?> mockContext;

    @BeforeEach
    public void createProcessors() {
        this.shouldContinue1 = (Processor)Mockito.mock(Processor.class);
        Mockito.when((Object)this.shouldContinue1.execute((ProcessingContext)((SelectContext)ArgumentMatchers.any()))).thenReturn((Object)ProcessorOutcome.CONTINUE);
        this.shouldContinue2 = (Processor)Mockito.mock(Processor.class);
        Mockito.when((Object)this.shouldContinue2.execute((ProcessingContext)((SelectContext)ArgumentMatchers.any()))).thenReturn((Object)ProcessorOutcome.CONTINUE);
        this.shouldStop = (Processor)Mockito.mock(Processor.class);
        Mockito.when((Object)this.shouldStop.execute((ProcessingContext)((SelectContext)ArgumentMatchers.any()))).thenReturn((Object)ProcessorOutcome.STOP);
        this.mockContext = (SelectContext)Mockito.mock(SelectContext.class);
    }

    @Test
    public void testAndThen() {
        Processor start = c -> ProcessorOutcome.CONTINUE;
        start.andThen(this.shouldContinue1).andThen(this.shouldContinue2).execute(this.mockContext);
        ((Processor)Mockito.verify(this.shouldContinue1)).execute(this.mockContext);
        ((Processor)Mockito.verify(this.shouldContinue2)).execute(this.mockContext);
    }

    @Test
    public void testAndThen_Stop() {
        Processor start = c -> ProcessorOutcome.CONTINUE;
        start.andThen(this.shouldContinue1).andThen(this.shouldStop).andThen(this.shouldContinue2).execute(this.mockContext);
        ((Processor)Mockito.verify(this.shouldContinue1)).execute(this.mockContext);
        ((Processor)Mockito.verify(this.shouldStop)).execute(this.mockContext);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.shouldContinue2});
    }
}

