/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.protocol.junit;

import io.agrest.meta.AgAttribute;
import io.agrest.protocol.Exp;
import io.agrest.protocol.Sort;
import io.agrest.runtime.processor.select.SelectContext;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;

public class ControlParamsChecker {
    private final SelectContext<?> context;

    public ControlParamsChecker(SelectContext<?> context) {
        this.context = context;
    }

    public ControlParamsChecker assertExp(Exp expectedExp) {
        Assertions.assertEquals((Object)expectedExp, (Object)this.context.getEntity().getExp());
        return this;
    }

    public ControlParamsChecker assertSort(Sort ... expectedOrderings) {
        List actualOrderings = this.context.getEntity().getOrderings();
        Assertions.assertEquals((int)expectedOrderings.length, (int)actualOrderings.size());
        Assertions.assertArrayEquals((Object[])expectedOrderings, (Object[])actualOrderings.toArray(new Sort[0]));
        return this;
    }

    public ControlParamsChecker assertIdIncluded() {
        Assertions.assertTrue((boolean)this.context.getEntity().isIdIncluded());
        return this;
    }

    public ControlParamsChecker assertIdExcluded() {
        Assertions.assertFalse((boolean)this.context.getEntity().isIdIncluded());
        return this;
    }

    public ControlParamsChecker assertAttributes(String ... expectedAttributes) {
        String expectedAsString = Arrays.stream(expectedAttributes).sorted().collect(Collectors.joining(","));
        String actualAsString = this.context.getEntity().getBaseProjection().getAttributes().stream().map(AgAttribute::getName).sorted().collect(Collectors.joining(","));
        Assertions.assertEquals((Object)expectedAsString, (Object)actualAsString);
        return this;
    }

    public ControlParamsChecker assertRelationships(String ... expectedRelationships) {
        String expectedAsString = Arrays.stream(expectedRelationships).sorted().collect(Collectors.joining(","));
        String actualAsString = this.context.getEntity().getChildren().stream().map(re -> re.getIncoming().getName()).sorted().collect(Collectors.joining(","));
        Assertions.assertEquals((Object)expectedAsString, (Object)actualAsString);
        return this;
    }
}

