/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.resolver;

import io.agrest.pojo.model.P3;
import io.agrest.pojo.model.P4;
import io.agrest.pojo.model.P5;
import io.agrest.resolver.ToManyFlattenedIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ToManyFlattenedIteratorTest {
    @Test
    public void testIterator_Empty() {
        List parents = Collections.emptyList();
        ToManyFlattenedIterator children = new ToManyFlattenedIterator(parents.iterator(), p -> ((P5)p).getP4s());
        Assertions.assertFalse((boolean)children.hasNext());
    }

    @Test
    public void testIterator() {
        List<P5> parents = Arrays.asList(this.newP5("a", 1), this.newP5("b", 0), this.newP5("c", 2));
        ToManyFlattenedIterator children = new ToManyFlattenedIterator(parents.iterator(), p -> ((P5)p).getP4s());
        ArrayList result = new ArrayList();
        children.forEachRemaining(result::add);
        Assertions.assertEquals((int)3, (int)result.size());
        Assertions.assertEquals((Object)"a_p3_0", (Object)((P4)result.get(0)).getP3().getName());
        Assertions.assertEquals((Object)"c_p3_0", (Object)((P4)result.get(1)).getP3().getName());
        Assertions.assertEquals((Object)"c_p3_1", (Object)((P4)result.get(2)).getP3().getName());
    }

    private P5 newP5(String label, int e4Count) {
        P5 p5 = new P5();
        ArrayList<P4> relationship = new ArrayList<P4>(e4Count);
        for (int i = 0; i < e4Count; ++i) {
            relationship.add(this.newP4(label + "_p3_" + i));
        }
        p5.setP4s(relationship);
        return p5;
    }

    private P4 newP4(String label) {
        P4 p4 = new P4();
        P3 p3 = new P3();
        p3.setName(label);
        p4.setP3(p3);
        return p4;
    }
}

