/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.resolver;

import io.agrest.pojo.model.P3;
import io.agrest.pojo.model.P4;
import io.agrest.resolver.ToOneFlattenedIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ToOneFlattenedIteratorTest {
    @Test
    public void testIterator_Empty() {
        List parents = Collections.emptyList();
        ToOneFlattenedIterator children = new ToOneFlattenedIterator(parents.iterator(), p -> ((P4)p).getP3());
        Assertions.assertFalse((boolean)children.hasNext());
    }

    @Test
    public void testIterator() {
        List<P4> parents = Arrays.asList(this.newP4("a", true), this.newP4("b", false), this.newP4("c", true));
        ToOneFlattenedIterator children = new ToOneFlattenedIterator(parents.iterator(), p -> ((P4)p).getP3());
        ArrayList result = new ArrayList();
        children.forEachRemaining(result::add);
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertEquals((Object)"a_e2", (Object)((P3)result.get(0)).getName());
        Assertions.assertEquals((Object)"c_e2", (Object)((P3)result.get(1)).getName());
    }

    private P4 newP4(String label, boolean e3) {
        P4 p4 = new P4();
        if (e3) {
            p4.setP3(this.newP3(label + "_e2"));
        }
        return p4;
    }

    private P3 newP3(String label) {
        P3 e2 = new P3();
        e2.setName(label);
        return e2;
    }
}

