/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime;

import io.agrest.AgException;
import io.agrest.runtime.AgExceptionMappers;
import io.agrest.spi.AgExceptionMapper;
import java.util.Collections;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AgExceptionMappersTest {
    @Test
    public void testToAgException_Default() {
        AgException e = new AgExceptionMappers(Collections.emptyMap()).toAgException(new Throwable());
        this.assertException(500, "Exception processing Agrest request", e);
    }

    @Test
    public void testToAgException() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(IllegalStateException.class.getName(), new IllegalStateMapper());
        map.put(IllegalArgumentException.class.getName(), new IllegalArgumentMapper());
        AgExceptionMappers mappers = new AgExceptionMappers(map);
        AgException illegalState = mappers.toAgException((Throwable)new IllegalStateException());
        this.assertException(500, "_IllegalStateException_", illegalState);
        AgException illegalArgument = mappers.toAgException((Throwable)new IllegalArgumentException());
        this.assertException(400, "_IllegalArgumentException_", illegalArgument);
    }

    @Test
    public void testLocateMapper_ExplicitlyMapped() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(RuntimeException.class.getName(), new RuntimeMapper());
        map.put(IllegalArgumentException.class.getName(), new IllegalArgumentMapper());
        AgExceptionMappers mappers = new AgExceptionMappers(map);
        AgExceptionMapper mapper = mappers.locateMapper(IllegalArgumentException.class);
        Assertions.assertTrue((boolean)(mapper instanceof IllegalArgumentMapper));
        Assertions.assertSame((Object)mapper, (Object)mappers.locateMapper(IllegalArgumentException.class));
    }

    @Test
    public void testLocateMapper_SuperException() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(RuntimeException.class.getName(), new RuntimeMapper());
        map.put(IllegalArgumentException.class.getName(), new IllegalArgumentMapper());
        AgExceptionMappers mappers = new AgExceptionMappers(map);
        AgExceptionMapper mapper = mappers.locateMapper(IllegalStateException.class);
        Assertions.assertTrue((boolean)(mapper instanceof RuntimeMapper));
        Assertions.assertSame((Object)mapper, (Object)mappers.locateMapper(IllegalStateException.class));
        Assertions.assertSame((Object)mapper, (Object)mappers.locateMapper(RuntimeException.class));
    }

    @Test
    public void testLocateMapper_DefaultMapper() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(RuntimeException.class.getName(), new RuntimeMapper());
        map.put(IllegalArgumentException.class.getName(), new IllegalArgumentMapper());
        AgExceptionMappers mappers = new AgExceptionMappers(map);
        AgExceptionMapper mapper = mappers.locateMapper(Error.class);
        Assertions.assertSame((Object)mappers.defaultMapper(), (Object)mapper);
        Assertions.assertSame((Object)mapper, (Object)mappers.locateMapper(Error.class));
    }

    private void assertException(int expectedStatus, String expectedMessage, AgException exception) {
        Assertions.assertEquals((int)expectedStatus, (int)exception.getStatus(), (String)"Unexpected status");
        Assertions.assertEquals((Object)expectedMessage, (Object)exception.getMessage(), (String)"Unexpected message");
    }

    static class IllegalArgumentMapper
    implements AgExceptionMapper<IllegalArgumentException> {
        IllegalArgumentMapper() {
        }

        public AgException toAgException(IllegalArgumentException e) {
            return AgException.badRequest((Throwable)e, (String)"_IllegalArgumentException_", (Object[])new Object[0]);
        }
    }

    static class IllegalStateMapper
    implements AgExceptionMapper<IllegalStateException> {
        IllegalStateMapper() {
        }

        public AgException toAgException(IllegalStateException e) {
            return AgException.internalServerError((Throwable)e, (String)"_IllegalStateException_", (Object[])new Object[0]);
        }
    }

    static class RuntimeMapper
    implements AgExceptionMapper<RuntimeException> {
        RuntimeMapper() {
        }

        public AgException toAgException(RuntimeException e) {
            return AgException.internalServerError((Throwable)e, (String)"_RuntimeException_", (Object[])new Object[0]);
        }
    }
}

