/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime;

import io.agrest.AgException;
import io.agrest.SelectStage;
import io.agrest.junit.AgPojoTester;
import io.agrest.pojo.model.P1;
import io.agrest.pojo.model.P2;
import io.agrest.spi.AgExceptionMapper;
import io.bootique.junit5.BQTest;
import io.bootique.junit5.BQTestTool;
import org.apache.cayenne.di.Module;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@BQTest
public class AgRuntimeBuilder_ExceptionMappersIT {
    @BQTestTool
    static final AgPojoTester tester = AgPojoTester.builder().agCustomizer(b -> b.module(AgRuntimeBuilder_ExceptionMappersIT.exceptionsModule())).build();

    private static Module exceptionsModule() {
        return cb -> cb.bindMap(AgExceptionMapper.class).put(AgException.class.getName(), TestAgExceptionMapper.class).put(TestException.class.getName(), TestExceptionMapper.class);
    }

    @Test
    public void testExceptionMapper_OverrideStandardMapper() {
        try {
            tester.runtime().select(P1.class).stage(SelectStage.APPLY_SERVER_PARAMS, c -> {
                throw AgException.forbidden((String)"_ag_exception_", (Object[])new Object[0]);
            }).get();
        }
        catch (AgException e) {
            Assertions.assertEquals((Object)"_ag__ag_exception_", (Object)e.getMessage());
        }
    }

    @Test
    public void testExceptionMapper_CustomExceptionMapper() {
        try {
            tester.runtime().select(P2.class).stage(SelectStage.APPLY_SERVER_PARAMS, c -> {
                throw new TestException("_test_exception_");
            }).get();
        }
        catch (AgException e) {
            Assertions.assertEquals((Object)"_test__test_exception_", (Object)e.getMessage());
        }
    }

    public static class TestException
    extends RuntimeException {
        public TestException(String message) {
            super(message);
        }
    }

    public static class TestExceptionMapper
    implements AgExceptionMapper<TestException> {
        public AgException toAgException(TestException e) {
            return AgException.internalServerError((Throwable)e, (String)"_test_%s", (Object[])new Object[]{e.getMessage()});
        }
    }

    public static class TestAgExceptionMapper
    implements AgExceptionMapper<AgException> {
        public AgException toAgException(AgException e) {
            return AgException.internalServerError((Throwable)e, (String)"_ag_%s", (Object[])new Object[]{e.getMessage()});
        }
    }
}

