/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime;

import io.agrest.access.PathChecker;
import io.agrest.runtime.AgRuntime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AgRuntimeBuilder_MaxPathDepthTest {
    @Test
    public void testDefault() {
        AgRuntime runtime = AgRuntime.builder().build();
        Assertions.assertEquals((int)100, (int)((PathChecker)runtime.service(PathChecker.class)).getDepth());
    }

    @Test
    public void testOverride() {
        AgRuntime runtime = AgRuntime.builder().maxPathDepth(3).build();
        Assertions.assertEquals((int)3, (int)((PathChecker)runtime.service(PathChecker.class)).getDepth());
    }

    @Test
    public void testOverrideZero() {
        AgRuntime runtime = AgRuntime.builder().maxPathDepth(0).build();
        Assertions.assertEquals((int)0, (int)((PathChecker)runtime.service(PathChecker.class)).getDepth());
    }

    @Test
    public void testNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AgRuntime.builder().maxPathDepth(-1));
    }
}

