/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import io.agrest.AgModuleProvider;
import io.agrest.TestModuleProvider;
import io.agrest.converter.jsonvalue.JsonValueConverter;
import io.agrest.runtime.AgRuntime;
import io.agrest.runtime.AgRuntimeBuilder;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Module;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AgRuntimeBuilder_ModuleProviderTest {
    static final String CONVERTER_KEY = X.class.getName();

    @Test
    public void testAgModule_Provider() {
        this.inRuntime(new AgRuntimeBuilder().module((AgModuleProvider)new LocalTestModuleProvider()), this::assertLocalTestModuleActive);
    }

    @Test
    public void testModule() {
        this.inRuntime(new AgRuntimeBuilder().module((Module)new LocalTestModule()), this::assertLocalTestModuleActive);
    }

    @Test
    public void testAutoLoading() {
        this.inRuntime(new AgRuntimeBuilder(), this::assertTestModuleActive);
    }

    @Test
    public void testSuppressAutoLoading() {
        this.inRuntime(new AgRuntimeBuilder().doNotAutoLoadModules(), this::assertTestModuleNotActive);
    }

    private void assertLocalTestModuleActive(AgRuntime runtime) {
        Map converters = (Map)runtime.service(Key.getMapOf(String.class, JsonValueConverter.class));
        Assertions.assertTrue((boolean)converters.containsKey(CONVERTER_KEY));
    }

    private void assertTestModuleActive(AgRuntime runtime) {
        Map converters = (Map)runtime.service(Key.getMapOf(String.class, JsonValueConverter.class));
        Assertions.assertTrue((boolean)converters.containsKey(TestModuleProvider.CONVERTER_KEY), (String)"Auto-loading was off");
    }

    private void assertTestModuleNotActive(AgRuntime runtime) {
        Map converters = (Map)runtime.service(Key.getMapOf(String.class, JsonValueConverter.class));
        Assertions.assertFalse((boolean)converters.containsKey(TestModuleProvider.CONVERTER_KEY), (String)"Auto-loading was on");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inRuntime(AgRuntimeBuilder builder, Consumer<AgRuntime> test) {
        AgRuntime r = builder.build();
        try {
            test.accept(r);
        }
        finally {
            r.shutdown();
        }
    }

    public static class XConverter
    implements JsonValueConverter<X> {
        public X value(JsonNode node) {
            return null;
        }
    }

    public static class X {
    }

    public static class LocalTestModule
    implements Module {
        public void configure(Binder binder) {
            binder.bindMap(JsonValueConverter.class).put(CONVERTER_KEY, (Object)new XConverter());
        }
    }

    static class LocalTestModuleProvider
    implements AgModuleProvider {
        LocalTestModuleProvider() {
        }

        public Module module() {
            return new LocalTestModule();
        }

        public Class<? extends Module> moduleType() {
            return LocalTestModule.class;
        }
    }
}

