/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime;

import io.agrest.RelatedResourceEntity;
import io.agrest.annotation.AgAttribute;
import io.agrest.annotation.AgRelationship;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgSchema;
import io.agrest.processor.ProcessingContext;
import io.agrest.reader.DataReader;
import io.agrest.resolver.ReaderBasedResolver;
import io.agrest.resolver.RelatedDataResolver;
import io.agrest.runtime.AgRuntime;
import io.agrest.runtime.processor.select.SelectContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AgRuntimeBuilder_OverlayTest {
    @Test
    public void testOverlay_RedefineAttribute_New() {
        AgRuntime runtime = AgRuntime.builder().entityOverlay(AgEntity.overlay(X.class).attribute("adHoc", Integer.class, true, true, e -> 2)).build();
        X x = new X();
        x.setName("aname");
        AgEntity entity = ((AgSchema)runtime.service(AgSchema.class)).getEntity(X.class);
        Assertions.assertNotNull((Object)entity);
        io.agrest.meta.AgAttribute x_adHoc = entity.getAttribute("adHoc");
        Assertions.assertNotNull((Object)x_adHoc);
        Assertions.assertEquals(Integer.class, (Object)x_adHoc.getType());
        Assertions.assertEquals((Object)2, (Object)x_adHoc.getDataReader().read((Object)x));
        io.agrest.meta.AgAttribute x_Unchanged = entity.getAttribute("name");
        Assertions.assertNotNull((Object)x_Unchanged);
        Assertions.assertEquals(String.class, (Object)x_Unchanged.getType());
        Assertions.assertEquals((Object)"aname", (Object)x_Unchanged.getDataReader().read((Object)x));
    }

    @Test
    public void testOverlay_RedefineAttribute_Replace() {
        AgRuntime runtime = AgRuntime.builder().entityOverlay(AgEntity.overlay(X.class).attribute("phoneNumber", Long.class, x -> Long.valueOf(x.getPhoneNumber()))).build();
        X x2 = new X();
        x2.setName("aname");
        x2.setPhoneNumber("3333333");
        AgEntity entity = ((AgSchema)runtime.service(AgSchema.class)).getEntity(X.class);
        Assertions.assertNotNull((Object)entity);
        io.agrest.meta.AgAttribute replaced = entity.getAttribute("phoneNumber");
        Assertions.assertNotNull((Object)replaced);
        Assertions.assertEquals(Long.class, (Object)replaced.getType());
        Assertions.assertEquals((Object)3333333L, (Object)replaced.getDataReader().read((Object)x2));
        io.agrest.meta.AgAttribute unchanged = entity.getAttribute("name");
        Assertions.assertNotNull((Object)unchanged);
        Assertions.assertEquals(String.class, (Object)unchanged.getType());
        Assertions.assertEquals((Object)"aname", (Object)unchanged.getDataReader().read((Object)x2));
    }

    @Test
    public void testOverlay_RedefineRelationshipResolver_Replace() {
        TestRelatedDataResolver resolver = new TestRelatedDataResolver();
        AgRuntime runtime = AgRuntime.builder().entityOverlay(AgEntity.overlay(X.class).relatedDataResolver("y", (t, n) -> resolver)).build();
        AgSchema metadata = (AgSchema)runtime.service(AgSchema.class);
        AgEntity entity = metadata.getEntity(X.class);
        Assertions.assertNotNull((Object)entity);
        io.agrest.meta.AgRelationship replaced = entity.getRelationship("y");
        Assertions.assertNotNull((Object)replaced);
        Assertions.assertSame((Object)metadata.getEntity(Y.class), (Object)replaced.getTargetEntity());
        Assertions.assertSame(resolver, (Object)replaced.getDataResolver());
        Assertions.assertFalse((boolean)replaced.isToMany());
        io.agrest.meta.AgRelationship unchanged = entity.getRelationship("z");
        Assertions.assertNotNull((Object)unchanged);
        Assertions.assertSame((Object)metadata.getEntity(Z.class), (Object)unchanged.getTargetEntity());
        Assertions.assertNotSame(resolver, (Object)unchanged.getDataResolver());
        Assertions.assertTrue((boolean)(unchanged.getDataResolver() instanceof ReaderBasedResolver));
        Assertions.assertFalse((boolean)unchanged.isToMany());
    }

    @Test
    public void testOverlay_RedefineRelationshipResolver_New() {
        TestRelatedDataResolver resolver = new TestRelatedDataResolver();
        AgRuntime runtime = AgRuntime.builder().entityOverlay(AgEntity.overlay(X.class).relatedDataResolver("adHoc", (t, n) -> resolver)).build();
        AgSchema metadata = (AgSchema)runtime.service(AgSchema.class);
        AgEntity entity = metadata.getEntity(X.class);
        Assertions.assertThrows(IllegalStateException.class, () -> entity.getRelationship("adHoc"));
    }

    @Test
    public void testOverlay_RedefineToMany_Replace() {
        TestRelatedDataResolver resolver = new TestRelatedDataResolver();
        AgRuntime runtime = AgRuntime.builder().entityOverlay(AgEntity.overlay(X.class).toMany("y", A.class, (t, n) -> resolver)).build();
        AgSchema metadata = (AgSchema)runtime.service(AgSchema.class);
        AgEntity entity = metadata.getEntity(X.class);
        Assertions.assertNotNull((Object)entity);
        io.agrest.meta.AgRelationship replaced = entity.getRelationship("y");
        Assertions.assertNotNull((Object)replaced);
        Assertions.assertSame((Object)metadata.getEntity(A.class), (Object)replaced.getTargetEntity());
        Assertions.assertSame(resolver, (Object)replaced.getDataResolver());
        Assertions.assertTrue((boolean)replaced.isToMany());
        io.agrest.meta.AgRelationship unchanged = entity.getRelationship("z");
        Assertions.assertNotNull((Object)unchanged);
        Assertions.assertSame((Object)metadata.getEntity(Z.class), (Object)unchanged.getTargetEntity());
        Assertions.assertNotSame(resolver, (Object)unchanged.getDataResolver());
        Assertions.assertTrue((boolean)(unchanged.getDataResolver() instanceof ReaderBasedResolver));
        Assertions.assertFalse((boolean)unchanged.isToMany());
    }

    @Test
    public void testOverlay_RedefineToOne_New() {
        TestRelatedDataResolver resolver = new TestRelatedDataResolver();
        AgRuntime runtime = AgRuntime.builder().entityOverlay(AgEntity.overlay(X.class).toOne("adHoc", A.class, true, true, (t, n) -> resolver)).build();
        AgSchema metadata = (AgSchema)runtime.service(AgSchema.class);
        AgEntity entity = metadata.getEntity(X.class);
        Assertions.assertNotNull((Object)entity);
        io.agrest.meta.AgRelationship created = entity.getRelationship("adHoc");
        Assertions.assertNotNull((Object)created);
        Assertions.assertSame((Object)metadata.getEntity(A.class), (Object)created.getTargetEntity());
        Assertions.assertSame(resolver, (Object)created.getDataResolver());
        Assertions.assertFalse((boolean)created.isToMany());
        io.agrest.meta.AgRelationship unchanged = entity.getRelationship("z");
        Assertions.assertNotNull((Object)unchanged);
        Assertions.assertSame((Object)metadata.getEntity(Z.class), (Object)unchanged.getTargetEntity());
        Assertions.assertNotSame(resolver, (Object)unchanged.getDataResolver());
        Assertions.assertTrue((boolean)(unchanged.getDataResolver() instanceof ReaderBasedResolver));
        Assertions.assertFalse((boolean)unchanged.isToMany());
    }

    @Test
    public void testOverlay_Exclude() {
        AgRuntime runtime = AgRuntime.builder().entityOverlay(AgEntity.overlay(X.class).readablePropFilter(b -> b.property("phoneNumber", false))).entityOverlay(AgEntity.overlay(X.class).writablePropFilter(b -> b.property("phoneNumber", false))).build();
        AgEntity entity = ((AgSchema)runtime.service(AgSchema.class)).getEntity(X.class);
        io.agrest.meta.AgAttribute phone = entity.getAttribute("phoneNumber");
        Assertions.assertNotNull((Object)phone);
        Assertions.assertFalse((boolean)phone.isReadable());
        Assertions.assertFalse((boolean)phone.isWritable());
    }

    public static class A {
    }

    public static class Z {
    }

    public static class Y {
    }

    public static class X {
        private String name;
        private String phoneNumber;
        private Y y;
        private Z z;

        @AgAttribute
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @AgAttribute
        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @AgRelationship
        public Y getY() {
            return this.y;
        }

        public void setY(Y y) {
            this.y = y;
        }

        @AgRelationship
        public Z getZ() {
            return this.z;
        }

        public void setZ(Z z) {
            this.z = z;
        }
    }

    static class TestRelatedDataResolver<T>
    implements RelatedDataResolver<T> {
        TestRelatedDataResolver() {
        }

        public void onParentQueryAssembled(RelatedResourceEntity<T> entity, SelectContext<?> context) {
            throw new UnsupportedOperationException();
        }

        public void onParentDataResolved(RelatedResourceEntity<T> entity, Iterable<?> parentData, SelectContext<?> context) {
            throw new UnsupportedOperationException();
        }

        public DataReader dataReader(RelatedResourceEntity<T> entity, ProcessingContext<?> context) {
            throw new UnsupportedOperationException();
        }
    }
}

