/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime;

import io.agrest.AgRequestBuilder;
import io.agrest.SelectStage;
import io.agrest.access.PathChecker;
import io.agrest.pojo.model.P1;
import io.agrest.processor.Processor;
import io.agrest.processor.ProcessorOutcome;
import io.agrest.runtime.DefaultSelectBuilder;
import io.agrest.runtime.processor.select.SelectContext;
import io.agrest.runtime.processor.select.SelectProcessorFactory;
import java.util.ArrayList;
import java.util.EnumMap;
import org.apache.cayenne.di.Injector;
import org.junit.jupiter.api.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class DefaultSelectBuilderTest {
    private <T> DefaultSelectBuilder<T> createBuilder(Class<T> type) {
        SelectContext context = new SelectContext(type, (AgRequestBuilder)Mockito.mock(AgRequestBuilder.class), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        SelectProcessorFactory processorFactory = (SelectProcessorFactory)Mockito.mock(SelectProcessorFactory.class);
        Mockito.when((Object)processorFactory.createProcessor((EnumMap)Matchers.any())).thenReturn((Object)((Processor)Mockito.mock(Processor.class)));
        return new DefaultSelectBuilder(context, processorFactory);
    }

    @Test
    public void testStage_FunctionTypes() {
        this.createBuilder(P1.class).stage(SelectStage.APPLY_SERVER_PARAMS, this::doSomething0).stage(SelectStage.APPLY_SERVER_PARAMS, this::doSomething1).stage(SelectStage.APPLY_SERVER_PARAMS, this::doSomething2).stage(SelectStage.APPLY_SERVER_PARAMS, this::doSomething3).stage(SelectStage.APPLY_SERVER_PARAMS, this::doSomething4).stage(SelectStage.APPLY_SERVER_PARAMS, s -> {}).stage(SelectStage.APPLY_SERVER_PARAMS, s -> {});
    }

    @Test
    public void testTerminalStage_FunctionTypes() {
        this.createBuilder(P1.class).terminalStage(SelectStage.APPLY_SERVER_PARAMS, this::doSomething0).terminalStage(SelectStage.APPLY_SERVER_PARAMS, this::doSomething1).terminalStage(SelectStage.APPLY_SERVER_PARAMS, this::doSomething2).terminalStage(SelectStage.APPLY_SERVER_PARAMS, this::doSomething3).terminalStage(SelectStage.APPLY_SERVER_PARAMS, this::doSomething4).terminalStage(SelectStage.APPLY_SERVER_PARAMS, s -> {}).terminalStage(SelectStage.APPLY_SERVER_PARAMS, s -> {});
    }

    @Test
    public void testRoutingStage_FunctionTypes() {
        this.createBuilder(P1.class).routingStage(SelectStage.APPLY_SERVER_PARAMS, this::doSomethingAndReturn0).routingStage(SelectStage.APPLY_SERVER_PARAMS, this::doSomethingAndReturn1).routingStage(SelectStage.APPLY_SERVER_PARAMS, this::doSomethingAndReturn2).routingStage(SelectStage.APPLY_SERVER_PARAMS, this::doSomethingAndReturn3).routingStage(SelectStage.APPLY_SERVER_PARAMS, this::doSomethingAndReturn4).routingStage(SelectStage.APPLY_SERVER_PARAMS, s -> ProcessorOutcome.CONTINUE).routingStage(SelectStage.APPLY_SERVER_PARAMS, s -> ProcessorOutcome.CONTINUE);
    }

    private void doSomething0(SelectContext<?> c) {
    }

    private <T> void doSomething1(SelectContext<T> c) {
    }

    private void doSomething2(SelectContext<I1> c) {
        ArrayList<T1> data = new ArrayList<T1>();
        data.add(new T1());
        c.getEntity().setData(data);
    }

    private void doSomething3(SelectContext<Object> c) {
        c.getEntity().setData(new ArrayList());
    }

    private void doSomething4(SelectContext<P1> c) {
        c.getEntity().setData(new ArrayList());
    }

    private ProcessorOutcome doSomethingAndReturn0(SelectContext<?> c) {
        return ProcessorOutcome.CONTINUE;
    }

    private <T> ProcessorOutcome doSomethingAndReturn1(SelectContext<T> c) {
        return ProcessorOutcome.CONTINUE;
    }

    private ProcessorOutcome doSomethingAndReturn2(SelectContext<I1> c) {
        c.getEntity().setData(new ArrayList());
        return ProcessorOutcome.CONTINUE;
    }

    private ProcessorOutcome doSomethingAndReturn3(SelectContext<Object> c) {
        c.getEntity().setData(new ArrayList());
        return ProcessorOutcome.CONTINUE;
    }

    private ProcessorOutcome doSomethingAndReturn4(SelectContext<P1> c) {
        c.getEntity().setData(new ArrayList());
        c.getEntity().setData(new ArrayList());
        return ProcessorOutcome.CONTINUE;
    }

    static class T1
    implements I1 {
        T1() {
        }
    }

    static interface I1 {
    }
}

