/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime;

import io.agrest.AgRequestBuilder;
import io.agrest.UpdateStage;
import io.agrest.access.PathChecker;
import io.agrest.processor.Processor;
import io.agrest.processor.ProcessorOutcome;
import io.agrest.runtime.DefaultUpdateBuilder;
import io.agrest.runtime.processor.update.BaseUpdateProcessorFactory;
import io.agrest.runtime.processor.update.UpdateContext;
import io.agrest.runtime.processor.update.UpdateProcessorFactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.apache.cayenne.di.Injector;
import org.junit.jupiter.api.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class DefaultUpdateBuilderTest {
    private <T> DefaultUpdateBuilder<T> createBuilder(Class<T> type) {
        UpdateContext context = new UpdateContext(type, (AgRequestBuilder)Mockito.mock(AgRequestBuilder.class), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        UpdateProcessorFactory processorFactory = (UpdateProcessorFactory)Mockito.mock(UpdateProcessorFactory.class);
        Mockito.when((Object)processorFactory.createProcessor((EnumMap)Matchers.any())).thenReturn((Object)((Processor)Mockito.mock(Processor.class)));
        return new DefaultUpdateBuilder(context, (BaseUpdateProcessorFactory)processorFactory);
    }

    @Test
    public void testStage_FunctionTypes() {
        this.createBuilder(X.class).stage(UpdateStage.PARSE_REQUEST, this::doSomething0).stage(UpdateStage.PARSE_REQUEST, this::doSomething1).stage(UpdateStage.PARSE_REQUEST, this::doSomething2).stage(UpdateStage.PARSE_REQUEST, this::doSomething3).stage(UpdateStage.PARSE_REQUEST, this::doSomething4).stage(UpdateStage.PARSE_REQUEST, s -> {}).stage(UpdateStage.PARSE_REQUEST, s -> {});
    }

    @Test
    public void testTerminalStage_FunctionTypes() {
        this.createBuilder(X.class).terminalStage(UpdateStage.PARSE_REQUEST, this::doSomething0).terminalStage(UpdateStage.PARSE_REQUEST, this::doSomething1).terminalStage(UpdateStage.PARSE_REQUEST, this::doSomething2).terminalStage(UpdateStage.PARSE_REQUEST, this::doSomething3).terminalStage(UpdateStage.PARSE_REQUEST, this::doSomething4).terminalStage(UpdateStage.PARSE_REQUEST, s -> {}).terminalStage(UpdateStage.PARSE_REQUEST, s -> {});
    }

    @Test
    public void testRoutingStage_FunctionTypes() {
        this.createBuilder(X.class).routingStage(UpdateStage.PARSE_REQUEST, this::doSomethingAndReturn0).routingStage(UpdateStage.PARSE_REQUEST, this::doSomethingAndReturn1).routingStage(UpdateStage.PARSE_REQUEST, this::doSomethingAndReturn2).routingStage(UpdateStage.PARSE_REQUEST, this::doSomethingAndReturn3).routingStage(UpdateStage.PARSE_REQUEST, this::doSomethingAndReturn4).routingStage(UpdateStage.PARSE_REQUEST, s -> ProcessorOutcome.CONTINUE).routingStage(UpdateStage.PARSE_REQUEST, s -> ProcessorOutcome.CONTINUE);
    }

    private void doSomething0(UpdateContext<?> c) {
    }

    private <T> void doSomething1(UpdateContext<T> c) {
    }

    private void doSomething2(UpdateContext<I1> c) {
        c.getEntity().setData(new ArrayList());
        List objects = c.getEntity().getData();
        objects.add(new T1());
    }

    private void doSomething3(UpdateContext<Object> c) {
        c.getEntity().setData(new ArrayList());
    }

    private void doSomething4(UpdateContext<X> c) {
        c.getEntity().setData(new ArrayList());
        c.getEntity().setData(new ArrayList());
    }

    private ProcessorOutcome doSomethingAndReturn0(UpdateContext<?> c) {
        return ProcessorOutcome.CONTINUE;
    }

    private <T> ProcessorOutcome doSomethingAndReturn1(UpdateContext<T> c) {
        return ProcessorOutcome.CONTINUE;
    }

    private ProcessorOutcome doSomethingAndReturn2(UpdateContext<I1> c) {
        c.getEntity().setData(new ArrayList());
        return ProcessorOutcome.CONTINUE;
    }

    private ProcessorOutcome doSomethingAndReturn3(UpdateContext<Object> c) {
        c.getEntity().setData(new ArrayList());
        return ProcessorOutcome.CONTINUE;
    }

    private ProcessorOutcome doSomethingAndReturn4(UpdateContext<X> c) {
        c.getEntity().setData(new ArrayList());
        c.getEntity().setData(new ArrayList());
        return ProcessorOutcome.CONTINUE;
    }

    public class X {
    }

    static class T1
    implements I1 {
        T1() {
        }
    }

    static interface I1 {
    }
}

