/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime.constraints;

import io.agrest.ResourceEntity;
import io.agrest.RootResourceEntity;
import io.agrest.SizeConstraints;
import io.agrest.annotation.AgAttribute;
import io.agrest.annotation.AgId;
import io.agrest.annotation.AgRelationship;
import io.agrest.compiler.AnnotationsAgEntityCompiler;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgSchema;
import io.agrest.meta.LazySchema;
import io.agrest.runtime.constraints.ConstraintsHandler;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ConstraintsHandlerTest {
    private static ConstraintsHandler constraintsHandler;
    private static AgSchema schema;

    @BeforeAll
    public static void before() {
        AnnotationsAgEntityCompiler compiler = new AnnotationsAgEntityCompiler(Map.of());
        schema = new LazySchema(List.of(compiler));
        constraintsHandler = new ConstraintsHandler();
    }

    @Test
    public void testConstrainResponseSize_FetchOffset() {
        AgEntity entity = schema.getEntity(Tr.class);
        SizeConstraints s1 = new SizeConstraints().fetchOffset(5);
        SizeConstraints s2 = new SizeConstraints().fetchOffset(0);
        RootResourceEntity t1 = new RootResourceEntity(entity);
        t1.setStart(0);
        constraintsHandler.constrainResponseSize((ResourceEntity)t1, s1);
        Assertions.assertEquals((int)0, (int)t1.getStart());
        Assertions.assertEquals((int)5, (int)s1.getFetchOffset());
        RootResourceEntity t2 = new RootResourceEntity(entity);
        t2.setStart(3);
        constraintsHandler.constrainResponseSize((ResourceEntity)t2, s1);
        Assertions.assertEquals((int)3, (int)t2.getStart());
        Assertions.assertEquals((int)5, (int)s1.getFetchOffset());
        RootResourceEntity t3 = new RootResourceEntity(entity);
        t3.setStart(6);
        constraintsHandler.constrainResponseSize((ResourceEntity)t3, s1);
        Assertions.assertEquals((int)5, (int)t3.getStart());
        Assertions.assertEquals((int)5, (int)s1.getFetchOffset());
        RootResourceEntity t4 = new RootResourceEntity(entity);
        t4.setStart(6);
        constraintsHandler.constrainResponseSize((ResourceEntity)t4, s2);
        Assertions.assertEquals((int)6, (int)t4.getStart());
        Assertions.assertEquals((int)0, (int)s2.getFetchOffset());
    }

    @Test
    public void testConstrainResponseSize_FetchLimit() {
        AgEntity entity = schema.getEntity(Tr.class);
        SizeConstraints s1 = new SizeConstraints().fetchLimit(5);
        SizeConstraints s2 = new SizeConstraints().fetchLimit(0);
        RootResourceEntity t1 = new RootResourceEntity(entity);
        constraintsHandler.constrainResponseSize((ResourceEntity)t1, s1);
        Assertions.assertEquals((int)5, (int)t1.getLimit());
        Assertions.assertEquals((int)5, (int)s1.getFetchLimit());
        RootResourceEntity t1_1 = new RootResourceEntity(entity);
        t1_1.setLimit(0);
        constraintsHandler.constrainResponseSize((ResourceEntity)t1_1, s1);
        Assertions.assertEquals((int)5, (int)t1_1.getLimit());
        Assertions.assertEquals((int)5, (int)s1.getFetchLimit());
        RootResourceEntity t1_2 = new RootResourceEntity(entity);
        t1_2.setLimit(-1);
        constraintsHandler.constrainResponseSize((ResourceEntity)t1_2, s1);
        Assertions.assertEquals((int)5, (int)t1_2.getLimit());
        Assertions.assertEquals((int)5, (int)s1.getFetchLimit());
        RootResourceEntity t2 = new RootResourceEntity(entity);
        t2.setLimit(3);
        constraintsHandler.constrainResponseSize((ResourceEntity)t2, s1);
        Assertions.assertEquals((int)3, (int)t2.getLimit());
        Assertions.assertEquals((int)5, (int)s1.getFetchLimit());
        RootResourceEntity t3 = new RootResourceEntity(entity);
        t3.setLimit(6);
        constraintsHandler.constrainResponseSize((ResourceEntity)t3, s1);
        Assertions.assertEquals((int)5, (int)t3.getLimit());
        Assertions.assertEquals((int)5, (int)s1.getFetchLimit());
        RootResourceEntity t4 = new RootResourceEntity(entity);
        t4.setLimit(6);
        constraintsHandler.constrainResponseSize((ResourceEntity)t4, s2);
        Assertions.assertEquals((int)6, (int)t4.getLimit());
        Assertions.assertEquals((int)0, (int)s2.getFetchLimit());
    }

    public static class Tv {
        @AgAttribute
        public String getP() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getZ() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Tu {
        @AgAttribute
        public String getK() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getL() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Tt {
        @AgAttribute
        public String getP() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getR() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Ts {
        @AgId
        public int getId() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getN() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getM() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getZ() {
            throw new UnsupportedOperationException();
        }

        @AgRelationship
        public Tt getRtt() {
            throw new UnsupportedOperationException();
        }

        @AgRelationship
        public List<Tr> getRtrs() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Tr {
        @AgId
        public int getId() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getA() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getB() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getC() {
            throw new UnsupportedOperationException();
        }

        @AgRelationship
        public Ts getRts() {
            throw new UnsupportedOperationException();
        }

        @AgRelationship
        public Tu getRtu() {
            throw new UnsupportedOperationException();
        }

        @AgRelationship
        public Tv getRtv() {
            throw new UnsupportedOperationException();
        }
    }
}

