/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime.constraints;

import io.agrest.ResourceEntity;
import io.agrest.RootResourceEntity;
import io.agrest.annotation.AgAttribute;
import io.agrest.annotation.AgId;
import io.agrest.annotation.AgRelationship;
import io.agrest.compiler.AnnotationsAgEntityCompiler;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgSchema;
import io.agrest.meta.LazySchema;
import io.agrest.runtime.constraints.ConstraintsHandler;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConstraintsHandlerWithDefaultsTest {
    static final ConstraintsHandler constraintsHandler = new ConstraintsHandler();
    static final AgSchema schema = new LazySchema(List.of(new AnnotationsAgEntityCompiler(Map.of())));

    @Test
    public void testConstrainResponse_Default() {
        AgEntity entity = schema.getEntity(Tr.class);
        RootResourceEntity te1 = new RootResourceEntity(entity);
        te1.ensureAttribute("a", false);
        te1.ensureAttribute("b", false);
        constraintsHandler.constrainResponse((ResourceEntity)te1);
        Assertions.assertEquals((int)1, (int)te1.getBaseProjection().getAttributes().size());
        Assertions.assertTrue((te1.getBaseProjection().getAttribute("a") != null ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)te1.getChildren().isEmpty());
    }

    @Test
    public void testConstrainResponse_None() {
        AgEntity entity = schema.getEntity(Ts.class);
        RootResourceEntity te1 = new RootResourceEntity(entity);
        te1.ensureAttribute("m", false);
        te1.ensureAttribute("n", false);
        constraintsHandler.constrainResponse((ResourceEntity)te1);
        Assertions.assertEquals((int)2, (int)te1.getBaseProjection().getAttributes().size());
        Assertions.assertTrue((te1.getBaseProjection().getAttribute("m") != null ? 1 : 0) != 0);
        Assertions.assertTrue((te1.getBaseProjection().getAttribute("n") != null ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)te1.getChildren().isEmpty());
    }

    public static class Ts {
        @AgId
        public int getId() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getN() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getM() {
            throw new UnsupportedOperationException();
        }

        @AgRelationship
        public List<Tr> getRtrs() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Tr {
        @AgId
        public int getId() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public int getA() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute(readable=false)
        public String getB() {
            throw new UnsupportedOperationException();
        }

        @AgRelationship
        public Ts getRts() {
            throw new UnsupportedOperationException();
        }
    }
}

