/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime.encoder;

import io.agrest.DataResponse;
import io.agrest.ResourceEntity;
import io.agrest.RootResourceEntity;
import io.agrest.annotation.AgAttribute;
import io.agrest.compiler.AnnotationsAgEntityCompiler;
import io.agrest.converter.valuestring.GenericConverter;
import io.agrest.converter.valuestring.ISOLocalDateConverter;
import io.agrest.converter.valuestring.ISOLocalDateTimeConverter;
import io.agrest.converter.valuestring.ISOLocalTimeConverter;
import io.agrest.converter.valuestring.ISOOffsetDateTimeConverter;
import io.agrest.converter.valuestring.ValueStringConverter;
import io.agrest.converter.valuestring.ValueStringConverters;
import io.agrest.encoder.Encoder;
import io.agrest.encoder.ValueEncodersProvider;
import io.agrest.meta.AgEntity;
import io.agrest.meta.LazySchema;
import io.agrest.processor.ProcessingContext;
import io.agrest.runtime.encoder.EncodablePropertyFactory;
import io.agrest.runtime.encoder.EncoderFactory;
import io.agrest.runtime.encoder.Encoders;
import io.agrest.runtime.encoder.IEncodablePropertyFactory;
import io.agrest.runtime.semantics.IRelationshipMapper;
import io.agrest.runtime.semantics.RelationshipMapper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class EncoderFactory_DateTime_Test {
    private AgEntity<PDate> dateEntity;
    private AgEntity<PTime> timeEntity;
    private AgEntity<PDateTime> dateTimeEntity;
    private AgEntity<POffsetDateTime> offsetDateTimeEntity;
    private EncoderFactory encoderFactory;

    @BeforeEach
    public void before() {
        Map<Class<OffsetDateTime>, ValueStringConverter> converterMap = Map.of(LocalDate.class, ISOLocalDateConverter.converter(), LocalTime.class, ISOLocalTimeConverter.converter(), LocalDateTime.class, ISOLocalDateTimeConverter.converter(), OffsetDateTime.class, ISOOffsetDateTimeConverter.converter());
        ValueStringConverters converters = new ValueStringConverters(converterMap, GenericConverter.converter());
        this.encoderFactory = new EncoderFactory((IEncodablePropertyFactory)new EncodablePropertyFactory(new ValueEncodersProvider(converters, Map.of()).get()), converters, (IRelationshipMapper)new RelationshipMapper());
        AnnotationsAgEntityCompiler compiler = new AnnotationsAgEntityCompiler(Map.of());
        LazySchema schema = new LazySchema(List.of(compiler));
        this.dateEntity = schema.getEntity(PDate.class);
        this.timeEntity = schema.getEntity(PTime.class);
        this.dateTimeEntity = schema.getEntity(PDateTime.class);
        this.offsetDateTimeEntity = schema.getEntity(POffsetDateTime.class);
    }

    @Test
    public void testLocalDate() {
        RootResourceEntity re = new RootResourceEntity(this.dateEntity);
        re.ensureAttribute("date", false);
        LocalDate localDate = LocalDate.now();
        PDate o = new PDate();
        o.setDate(localDate);
        String dateString = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(localDate);
        Assertions.assertEquals((Object)("{\"data\":[{\"date\":\"" + dateString + "\"}],\"total\":1}"), (Object)this.toJson(o, (ResourceEntity<?>)re));
    }

    @Test
    public void testLocalTime() {
        this.testLocalTime(LocalTime.of(10, 0, 0), "HH:mm:ss");
        this.testLocalTime(LocalTime.of(10, 0, 0, 1), "HH:mm:ss");
        this.testLocalTime(LocalTime.of(10, 0, 0, 999999), "HH:mm:ss");
        this.testLocalTime(LocalTime.of(10, 0, 0, 1000000), "HH:mm:ss.SSS");
    }

    private void testLocalTime(LocalTime time, String expectedPattern) {
        RootResourceEntity re = new RootResourceEntity(this.timeEntity);
        re.ensureAttribute("time", false);
        PTime o = new PTime();
        o.setTime(time);
        String timeString = DateTimeFormatter.ofPattern(expectedPattern).format(time);
        Assertions.assertEquals((Object)("{\"data\":[{\"time\":\"" + timeString + "\"}],\"total\":1}"), (Object)this.toJson(o, (ResourceEntity<?>)re));
    }

    @Test
    public void testLocalDateTime() {
        this.testLocalDateTime(LocalDateTime.of(2017, 1, 1, 10, 0, 0), "yyyy-MM-dd'T'HH:mm:ss");
        this.testLocalDateTime(LocalDateTime.of(2017, 1, 1, 10, 0, 0, 1), "yyyy-MM-dd'T'HH:mm:ss");
        this.testLocalDateTime(LocalDateTime.of(2017, 1, 1, 10, 0, 0, 999999), "yyyy-MM-dd'T'HH:mm:ss");
        this.testLocalDateTime(LocalDateTime.of(2017, 1, 1, 10, 0, 0, 1000000), "yyyy-MM-dd'T'HH:mm:ss.SSS");
    }

    private void testLocalDateTime(LocalDateTime dateTime, String expectedPattern) {
        RootResourceEntity re = new RootResourceEntity(this.dateTimeEntity);
        re.ensureAttribute("timestamp", false);
        PDateTime o = new PDateTime();
        o.setTimestamp(dateTime);
        String dateTimeString = DateTimeFormatter.ofPattern(expectedPattern).format(dateTime);
        Assertions.assertEquals((Object)("{\"data\":[{\"timestamp\":\"" + dateTimeString + "\"}],\"total\":1}"), (Object)this.toJson(o, (ResourceEntity<?>)re));
    }

    @Test
    public void testOffsetDateTime() {
        this.testOffsetDateTime(OffsetDateTime.of(LocalDateTime.of(2017, 1, 1, 10, 0, 0), ZoneOffset.ofHours(3)));
        this.testOffsetDateTime(OffsetDateTime.of(LocalDateTime.of(2017, 1, 1, 10, 0, 0, 1), ZoneOffset.ofHours(3)));
        this.testOffsetDateTime(OffsetDateTime.of(LocalDateTime.of(2017, 1, 1, 10, 0, 0, 999999), ZoneOffset.ofHours(3)));
        this.testOffsetDateTime(OffsetDateTime.of(LocalDateTime.of(2017, 1, 1, 10, 0, 0, 1000000), ZoneOffset.ofHours(3)));
    }

    private void testOffsetDateTime(OffsetDateTime dateTime) {
        RootResourceEntity re = new RootResourceEntity(this.offsetDateTimeEntity);
        re.ensureAttribute("timestamp", false);
        POffsetDateTime o = new POffsetDateTime();
        o.setTimestamp(dateTime);
        String dateTimeString = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(dateTime);
        Assertions.assertEquals((Object)("{\"data\":[{\"timestamp\":\"" + dateTimeString + "\"}],\"total\":1}"), (Object)this.toJson(o, (ResourceEntity<?>)re));
    }

    private String toJson(Object object, ResourceEntity<?> resourceEntity) {
        Encoder encoder = this.encoderFactory.encoder(resourceEntity, (ProcessingContext)Mockito.mock(ProcessingContext.class));
        return Encoders.toJson(DataResponse.of(List.of(object)).encoder(encoder).build());
    }

    public class POffsetDateTime {
        private OffsetDateTime timestamp;

        @AgAttribute
        public OffsetDateTime getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
        }
    }

    public class PDateTime {
        private LocalDateTime timestamp;

        @AgAttribute
        public LocalDateTime getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(LocalDateTime timestamp) {
            this.timestamp = timestamp;
        }
    }

    public class PTime {
        private LocalTime time;

        @AgAttribute
        public LocalTime getTime() {
            return this.time;
        }

        public void setTime(LocalTime time) {
            this.time = time;
        }
    }

    public class PDate {
        private LocalDate date;

        @AgAttribute
        public LocalDate getDate() {
            return this.date;
        }

        public void setDate(LocalDate date) {
            this.date = date;
        }
    }
}

