/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime.encoder;

import io.agrest.DataResponse;
import io.agrest.ResourceEntity;
import io.agrest.RootResourceEntity;
import io.agrest.compiler.AnnotationsAgEntityCompiler;
import io.agrest.converter.valuestring.ValueStringConverters;
import io.agrest.converter.valuestring.ValueStringConvertersProvider;
import io.agrest.encoder.Encoder;
import io.agrest.encoder.ValueEncodersProvider;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgSchema;
import io.agrest.meta.LazySchema;
import io.agrest.pojo.model.P1;
import io.agrest.pojo.model.P6;
import io.agrest.processor.ProcessingContext;
import io.agrest.runtime.encoder.EncodablePropertyFactory;
import io.agrest.runtime.encoder.EncoderFactory;
import io.agrest.runtime.encoder.Encoders;
import io.agrest.runtime.encoder.IEncodablePropertyFactory;
import io.agrest.runtime.semantics.IRelationshipMapper;
import io.agrest.runtime.semantics.RelationshipMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class EncoderFactory_Pojo_Test {
    static final AgSchema schema = new LazySchema(List.of(new AnnotationsAgEntityCompiler(Map.of())));
    private EncoderFactory encoderFactory;

    @BeforeEach
    public void setUp() {
        ValueStringConverters converters = new ValueStringConvertersProvider(Collections.emptyMap()).get();
        EncodablePropertyFactory epf = new EncodablePropertyFactory(new ValueEncodersProvider(converters, Collections.emptyMap()).get());
        this.encoderFactory = new EncoderFactory((IEncodablePropertyFactory)epf, converters, (IRelationshipMapper)new RelationshipMapper());
    }

    @Test
    public void testEncode_SimplePojo_noId() {
        AgEntity p1e = schema.getEntity(P1.class);
        RootResourceEntity re = new RootResourceEntity(p1e);
        re.ensureAttribute("name", false);
        P1 p1 = new P1();
        p1.setName("XYZ");
        Assertions.assertEquals((Object)"{\"data\":[{\"name\":\"XYZ\"}],\"total\":1}", (Object)this.toJson(p1, (ResourceEntity<?>)re));
    }

    @Test
    public void testEncode_SimplePojo_Id() {
        AgEntity p6e = schema.getEntity(P6.class);
        P6 p6 = new P6();
        p6.setStringId("myid");
        p6.setIntProp(4);
        RootResourceEntity re = new RootResourceEntity(p6e);
        re.ensureAttribute("intProp", false);
        re.includeId();
        Assertions.assertEquals((Object)"{\"data\":[{\"id\":\"myid\",\"intProp\":4}],\"total\":1}", (Object)this.toJson(p6, (ResourceEntity<?>)re));
    }

    private String toJson(Object object, ResourceEntity<?> resourceEntity) {
        Encoder encoder = this.encoderFactory.encoder(resourceEntity, (ProcessingContext)Mockito.mock(ProcessingContext.class));
        return Encoders.toJson(DataResponse.of(List.of(object)).encoder(encoder).build());
    }
}

