/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime.encoder;

import io.agrest.DataResponse;
import io.agrest.ResourceEntity;
import io.agrest.RootResourceEntity;
import io.agrest.annotation.AgAttribute;
import io.agrest.compiler.AnnotationsAgEntityCompiler;
import io.agrest.converter.valuestring.GenericConverter;
import io.agrest.converter.valuestring.ISODateConverter;
import io.agrest.converter.valuestring.ISODateTimeConverter;
import io.agrest.converter.valuestring.ISOTimeConverter;
import io.agrest.converter.valuestring.ValueStringConverter;
import io.agrest.converter.valuestring.ValueStringConverters;
import io.agrest.encoder.Encoder;
import io.agrest.encoder.ValueEncodersProvider;
import io.agrest.meta.AgEntity;
import io.agrest.meta.LazySchema;
import io.agrest.processor.ProcessingContext;
import io.agrest.runtime.encoder.EncodablePropertyFactory;
import io.agrest.runtime.encoder.EncoderFactory;
import io.agrest.runtime.encoder.Encoders;
import io.agrest.runtime.encoder.IEncodablePropertyFactory;
import io.agrest.runtime.semantics.IRelationshipMapper;
import io.agrest.runtime.semantics.RelationshipMapper;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class EncoderFactory_SqlDateTime_Test {
    private static final long EPOCH_MILLIS = 1458995247000L;
    private static final long EPOCH_MILLIS_WITH_FRACTION = 1458995247001L;
    private EncoderFactory encoderFactory;
    private AgEntity<PSqlDateTime> sqlDateTimeEntity;

    @BeforeEach
    public void before() {
        Map<Class<Time>, ValueStringConverter> converterMap = Map.of(Timestamp.class, ISODateTimeConverter.converter(), Date.class, ISODateConverter.converter(), Time.class, ISOTimeConverter.converter());
        ValueStringConverters converters = new ValueStringConverters(converterMap, GenericConverter.converter());
        this.encoderFactory = new EncoderFactory((IEncodablePropertyFactory)new EncodablePropertyFactory(new ValueEncodersProvider(converters, Collections.emptyMap()).get()), converters, (IRelationshipMapper)new RelationshipMapper());
        AnnotationsAgEntityCompiler compiler = new AnnotationsAgEntityCompiler(Collections.emptyMap());
        LazySchema schema = new LazySchema(List.of(compiler));
        this.sqlDateTimeEntity = schema.getEntity(PSqlDateTime.class);
    }

    @Test
    public void testJavaSqlDate() {
        RootResourceEntity re = new RootResourceEntity(this.sqlDateTimeEntity);
        re.ensureAttribute("date", false);
        Date date = new Date(1458995247000L);
        PSqlDateTime o = new PSqlDateTime();
        o.setDate(date);
        String dateString = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(this.toLocalDateTime(date));
        Assertions.assertEquals((Object)("{\"data\":[{\"date\":\"" + dateString + "\"}],\"total\":1}"), (Object)this.toJson(o, (ResourceEntity<?>)re));
    }

    @Test
    public void testJavaSqlTime() {
        this._testISOTimeEncoder_javaSqlTime(new Time(1458995247000L), "HH:mm:ss");
        this._testISOTimeEncoder_javaSqlTime(new Time(1458995247001L), "HH:mm:ss.SSS");
    }

    private void _testISOTimeEncoder_javaSqlTime(Time time, String expectedPattern) {
        RootResourceEntity re = new RootResourceEntity(this.sqlDateTimeEntity);
        re.ensureAttribute("time", false);
        PSqlDateTime o = new PSqlDateTime();
        o.setTime(time);
        String timeString = DateTimeFormatter.ofPattern(expectedPattern).format(this.toLocalDateTime(time));
        Assertions.assertEquals((Object)("{\"data\":[{\"time\":\"" + timeString + "\"}],\"total\":1}"), (Object)this.toJson(o, (ResourceEntity<?>)re));
    }

    @Test
    public void testJavaSqlTimestamp() {
        this._testISODateTimeEncoder_javaSqlTimestamp(new Timestamp(1458995247000L), "yyyy-MM-dd'T'HH:mm:ss");
        this._testISODateTimeEncoder_javaSqlTimestamp(new Timestamp(1458995247001L), "yyyy-MM-dd'T'HH:mm:ss.SSS");
    }

    private void _testISODateTimeEncoder_javaSqlTimestamp(Timestamp timestamp, String expectedPattern) {
        RootResourceEntity re = new RootResourceEntity(this.sqlDateTimeEntity);
        re.ensureAttribute("timestamp", false);
        PSqlDateTime o = new PSqlDateTime();
        o.setTimestamp(timestamp);
        String tsString = DateTimeFormatter.ofPattern(expectedPattern).format(this.toLocalDateTime(timestamp));
        Assertions.assertEquals((Object)("{\"data\":[{\"timestamp\":\"" + tsString + "\"}],\"total\":1}"), (Object)this.toJson(o, (ResourceEntity<?>)re));
    }

    private LocalDateTime toLocalDateTime(java.util.Date date) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
    }

    private String toJson(Object object, ResourceEntity<?> resourceEntity) {
        Encoder encoder = this.encoderFactory.encoder(resourceEntity, (ProcessingContext)Mockito.mock(ProcessingContext.class));
        return Encoders.toJson(DataResponse.of(List.of(object)).encoder(encoder).build());
    }

    public static class PSqlDateTime {
        private Date date;
        private Time time;
        private Timestamp timestamp;

        @AgAttribute
        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        @AgAttribute
        public Time getTime() {
            return this.time;
        }

        public void setTime(Time time) {
            this.time = time;
        }

        @AgAttribute
        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }
    }
}

