/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime.encoder;

import io.agrest.DataResponse;
import io.agrest.ResourceEntity;
import io.agrest.RootResourceEntity;
import io.agrest.annotation.AgAttribute;
import io.agrest.compiler.AnnotationsAgEntityCompiler;
import io.agrest.converter.valuestring.GenericConverter;
import io.agrest.converter.valuestring.ISODateTimeConverter;
import io.agrest.converter.valuestring.ValueStringConverter;
import io.agrest.converter.valuestring.ValueStringConverters;
import io.agrest.encoder.Encoder;
import io.agrest.encoder.ValueEncodersProvider;
import io.agrest.meta.AgEntity;
import io.agrest.meta.LazySchema;
import io.agrest.processor.ProcessingContext;
import io.agrest.runtime.encoder.EncodablePropertyFactory;
import io.agrest.runtime.encoder.EncoderFactory;
import io.agrest.runtime.encoder.Encoders;
import io.agrest.runtime.encoder.IEncodablePropertyFactory;
import io.agrest.runtime.semantics.IRelationshipMapper;
import io.agrest.runtime.semantics.RelationshipMapper;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class EncoderFactory_UtilDate_Test {
    private static final long EPOCH_MILLIS = 1458995247000L;
    private static final long EPOCH_MILLIS_WITH_FRACTION = 1458995247001L;
    private EncoderFactory encoderFactory;
    private AgEntity<PUtilDate> utilDateEntity;

    @BeforeEach
    public void before() {
        Map<Class<Date>, ValueStringConverter> converterMap = Map.of(Date.class, ISODateTimeConverter.converter());
        ValueStringConverters converters = new ValueStringConverters(converterMap, GenericConverter.converter());
        this.encoderFactory = new EncoderFactory((IEncodablePropertyFactory)new EncodablePropertyFactory(new ValueEncodersProvider(converters, Collections.emptyMap()).get()), converters, (IRelationshipMapper)new RelationshipMapper());
        AnnotationsAgEntityCompiler compiler = new AnnotationsAgEntityCompiler(Collections.emptyMap());
        LazySchema schema = new LazySchema(List.of(compiler));
        this.utilDateEntity = schema.getEntity(PUtilDate.class);
    }

    @Test
    public void testUtilDate() {
        this.testUtilDate(new Date(1458995247000L), "yyyy-MM-dd'T'HH:mm:ss");
        this.testUtilDate(new Date(1458995247001L), "yyyy-MM-dd'T'HH:mm:ss.SSS");
    }

    private void testUtilDate(Date date, String expectedPattern) {
        RootResourceEntity re = new RootResourceEntity(this.utilDateEntity);
        re.ensureAttribute("date", false);
        PUtilDate o = new PUtilDate();
        o.setDate(date);
        String dateString = DateTimeFormatter.ofPattern(expectedPattern).format(this.toLocalDateTime(date));
        Assertions.assertEquals((Object)("{\"data\":[{\"date\":\"" + dateString + "\"}],\"total\":1}"), (Object)this.toJson(o, (ResourceEntity<?>)re));
    }

    private LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
    }

    private String toJson(Object object, ResourceEntity<?> resourceEntity) {
        Encoder encoder = this.encoderFactory.encoder(resourceEntity, (ProcessingContext)Mockito.mock(ProcessingContext.class));
        return Encoders.toJson(DataResponse.of(List.of(object)).encoder(encoder).build());
    }

    public static class PUtilDate {
        private Date date;

        @AgAttribute
        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }
    }
}

