/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime.entity;

import io.agrest.RelatedResourceEntity;
import io.agrest.ResourceEntity;
import io.agrest.RootResourceEntity;
import io.agrest.access.PathChecker;
import io.agrest.annotation.AgAttribute;
import io.agrest.annotation.AgId;
import io.agrest.annotation.AgRelationship;
import io.agrest.compiler.AnnotationsAgEntityCompiler;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgEntityOverlay;
import io.agrest.meta.AgSchema;
import io.agrest.meta.LazySchema;
import io.agrest.protocol.Include;
import io.agrest.resolver.ThrowingRelatedDataResolver;
import io.agrest.runtime.entity.ExpMerger;
import io.agrest.runtime.entity.IExpMerger;
import io.agrest.runtime.entity.IMapByMerger;
import io.agrest.runtime.entity.ISizeMerger;
import io.agrest.runtime.entity.ISortMerger;
import io.agrest.runtime.entity.IncludeMerger;
import io.agrest.runtime.entity.MapByMerger;
import io.agrest.runtime.entity.SizeMerger;
import io.agrest.runtime.entity.SortMerger;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IncludeMergerTest {
    private AgSchema schema;
    private IncludeMerger includeMerger;

    @BeforeEach
    public void setUp() {
        AnnotationsAgEntityCompiler compiler = new AnnotationsAgEntityCompiler(Collections.emptyMap());
        this.schema = new LazySchema(List.of(compiler));
        ExpMerger expMerger = new ExpMerger();
        SortMerger sortMerger = new SortMerger();
        MapByMerger mapByMerger = new MapByMerger(this.schema);
        SizeMerger sizeMerger = new SizeMerger();
        this.includeMerger = new IncludeMerger(this.schema, (IExpMerger)expMerger, (ISortMerger)sortMerger, (IMapByMerger)mapByMerger, (ISizeMerger)sizeMerger);
    }

    @Test
    public void testMergeNothing() {
        AgEntity entity = this.schema.getEntity(X.class);
        RootResourceEntity root = new RootResourceEntity(entity);
        this.includeMerger.merge((ResourceEntity)root, Arrays.asList(new Include[0]), Collections.emptyMap(), PathChecker.ofDefault());
        Assertions.assertEquals((int)entity.getAttributes().size(), (int)root.getBaseProjection().getAttributes().size());
        Assertions.assertTrue((boolean)root.isIdIncluded());
        Assertions.assertEquals((int)0, (int)root.getChildren().size());
    }

    @Test
    public void testMergeAttributes() {
        AgEntity entity = this.schema.getEntity(X.class);
        RootResourceEntity root = new RootResourceEntity(entity);
        this.includeMerger.merge((ResourceEntity)root, Arrays.asList(new Include("name")), Collections.emptyMap(), PathChecker.ofDefault());
        Assertions.assertEquals((int)1, (int)root.getBaseProjection().getAttributes().size());
        Assertions.assertFalse((boolean)root.isIdIncluded());
        Assertions.assertEquals((int)0, (int)root.getChildren().size());
    }

    @Test
    public void testMergeAttributesAndRelationships() {
        AgEntity entity = this.schema.getEntity(X.class);
        RootResourceEntity root = new RootResourceEntity(entity);
        this.includeMerger.merge((ResourceEntity)root, Arrays.asList(new Include("name"), new Include("ys")), Collections.emptyMap(), PathChecker.ofDefault());
        Assertions.assertEquals((int)1, (int)root.getBaseProjection().getAttributes().size());
        Assertions.assertFalse((boolean)root.isIdIncluded());
        Assertions.assertEquals((int)1, (int)root.getChildren().size());
    }

    @Test
    public void testMerge_AttributesAndRelationships_OverlappedPath() {
        AgEntity entity = this.schema.getEntity(X.class);
        RootResourceEntity root = new RootResourceEntity(entity);
        this.includeMerger.merge((ResourceEntity)root, Arrays.asList(new Include("name"), new Include("ys.name"), new Include("ys.z")), Collections.emptyMap(), PathChecker.ofDefault());
        Assertions.assertEquals((int)1, (int)root.getBaseProjection().getAttributes().size());
        Assertions.assertFalse((boolean)root.isIdIncluded());
        Assertions.assertEquals((int)1, (int)root.getChildren().size());
        RelatedResourceEntity yChild = root.getChild("ys");
        Assertions.assertNotNull((Object)yChild);
        Assertions.assertEquals((int)1, (int)yChild.getBaseProjection().getAttributes().size());
        Assertions.assertFalse((boolean)yChild.isIdIncluded());
        Assertions.assertEquals((int)1, (int)yChild.getChildren().size());
        RelatedResourceEntity zChild = yChild.getChild("z");
        Assertions.assertNotNull((Object)zChild);
        Assertions.assertEquals((int)this.schema.getEntity(Z.class).getAttributes().size(), (int)zChild.getBaseProjection().getAttributes().size());
        Assertions.assertTrue((boolean)zChild.isIdIncluded());
        Assertions.assertEquals((int)0, (int)zChild.getChildren().size());
    }

    @Test
    public void testMerge_AttributesAndRelationships_OverlappedPath_Overlays() {
        HashMap<Class, AgEntityOverlay> overlays = new HashMap<Class, AgEntityOverlay>();
        overlays.put(X.class, AgEntity.overlay(X.class).relatedDataResolver("ys", (t, r) -> ThrowingRelatedDataResolver.getInstance()));
        overlays.put(Y.class, AgEntity.overlay(Y.class).relatedDataResolver("z", (t, r) -> ThrowingRelatedDataResolver.getInstance()));
        AgEntity entity = this.schema.getEntity(X.class);
        AgEntity entityOverlaid = entity.resolveOverlay(this.schema, (AgEntityOverlay)overlays.get(X.class));
        RootResourceEntity root = new RootResourceEntity(entityOverlaid);
        this.includeMerger.merge((ResourceEntity)root, Arrays.asList(new Include("name"), new Include("ys.name"), new Include("ys.z")), overlays, PathChecker.ofDefault());
        Assertions.assertEquals((int)1, (int)root.getBaseProjection().getAttributes().size());
        Assertions.assertFalse((boolean)root.isIdIncluded());
        Assertions.assertEquals((int)1, (int)root.getChildren().size());
        RelatedResourceEntity yChild = root.getChild("ys");
        Assertions.assertNotNull((Object)yChild);
        Assertions.assertEquals((int)1, (int)yChild.getBaseProjection().getAttributes().size());
        Assertions.assertFalse((boolean)yChild.isIdIncluded());
        Assertions.assertEquals((int)1, (int)yChild.getChildren().size());
        RelatedResourceEntity zChild = yChild.getChild("z");
        Assertions.assertNotNull((Object)zChild);
        Assertions.assertEquals((int)this.schema.getEntity(Z.class).getAttributes().size(), (int)zChild.getBaseProjection().getAttributes().size());
        Assertions.assertTrue((boolean)zChild.isIdIncluded());
        Assertions.assertEquals((int)0, (int)zChild.getChildren().size());
    }

    public static class A {
        private int id;

        @AgId
        public int getId() {
            return this.id;
        }
    }

    public static class Z {
        private int id;
        private String name;
        private A a;

        @AgId
        public int getId() {
            return this.id;
        }

        @AgAttribute
        public String getName() {
            return this.name;
        }

        @AgRelationship
        public A getA() {
            return this.a;
        }
    }

    public static class Y {
        private String name;
        private String phoneNumber;
        private Z z;

        @AgAttribute
        public String getName() {
            return this.name;
        }

        @AgAttribute
        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        @AgRelationship
        public Z getZ() {
            return this.z;
        }
    }

    public static class X {
        private int id;
        private LocalDate date;
        private String name;
        private List<Y> ys;

        @AgId
        public int getId() {
            return this.id;
        }

        @AgAttribute
        public LocalDate getDate() {
            return this.date;
        }

        @AgAttribute
        public String getName() {
            return this.name;
        }

        @AgRelationship
        public List<Y> getYs() {
            return this.ys;
        }
    }
}

