/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime.entity;

import io.agrest.runtime.entity.ResultFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResultFilterTest {
    @Test
    public void testFilterList_AllMatches() {
        List<Object> unfiltered = Arrays.asList("a", "b", "c");
        List filtered = ResultFilter.filterList(unfiltered, o -> true);
        Assertions.assertSame(unfiltered, (Object)filtered, (String)"No list copy should've been created");
    }

    @Test
    public void testFilterList_MatchStart() {
        List<String> unfiltered = Arrays.asList("a", "b", "ac");
        List filtered = ResultFilter.filterList(unfiltered, o -> o.startsWith("a"));
        Assertions.assertEquals(Arrays.asList("a", "ac"), (Object)filtered);
    }

    @Test
    public void testFilterList_MatchMiddle() {
        List<String> unfiltered = Arrays.asList("a", "b", "ac", "bb");
        List filtered = ResultFilter.filterList(unfiltered, o -> o.startsWith("b"));
        Assertions.assertEquals(Arrays.asList("b", "bb"), (Object)filtered);
    }

    @Test
    public void testFilterList_MatchEnd() {
        List<String> unfiltered = Arrays.asList("a", "b", "ac", "bb");
        List filtered = ResultFilter.filterList(unfiltered, o -> o.equals("bb"));
        Assertions.assertEquals(List.of("bb"), (Object)filtered);
    }

    @Test
    public void testFilterList_NoMatches() {
        List<String> unfiltered = Arrays.asList("a", "b", "ac", "bb");
        List filtered = ResultFilter.filterList(unfiltered, o -> false);
        Assertions.assertEquals(new ArrayList(), (Object)filtered);
    }
}

