/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime.jackson;

import io.agrest.AgException;
import io.agrest.runtime.jackson.JacksonService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JacksonServiceTest {
    @Test
    public void testOutputJson() throws IOException {
        JacksonService service = JacksonService.create();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        service.outputJson(o -> o.writeObject((Object)new X(1, "two")), (OutputStream)out);
        Assertions.assertEquals((Object)"{\"a\":1,\"b\":\"two\"}", (Object)out.toString());
    }

    @Test
    public void testParse_BadJson() {
        JacksonService service = JacksonService.create();
        try {
            service.parseJson("{bad}");
            Assertions.fail((String)"Exception expected");
        }
        catch (AgException e) {
            Assertions.assertEquals((Object)"Error parsing JSON", (Object)e.getMessage());
            Assertions.assertEquals((int)400, (int)e.getStatus());
            Assertions.assertNotNull((Object)e.getCause());
        }
    }

    public static class X {
        private final int a;
        private final String b;

        public X(int a, String b) {
            this.a = a;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public String getB() {
            return this.b;
        }
    }
}

