/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime.processor.select;

import io.agrest.RelatedResourceEntity;
import io.agrest.RootResourceEntity;
import io.agrest.access.PathChecker;
import io.agrest.annotation.AgAttribute;
import io.agrest.annotation.AgId;
import io.agrest.annotation.AgRelationship;
import io.agrest.compiler.AnnotationsAgEntityCompiler;
import io.agrest.meta.AgSchema;
import io.agrest.meta.LazySchema;
import io.agrest.protocol.Direction;
import io.agrest.protocol.Exclude;
import io.agrest.protocol.Exp;
import io.agrest.protocol.Include;
import io.agrest.protocol.Sort;
import io.agrest.runtime.entity.ExcludeMerger;
import io.agrest.runtime.entity.ExpMerger;
import io.agrest.runtime.entity.IExcludeMerger;
import io.agrest.runtime.entity.IExpMerger;
import io.agrest.runtime.entity.IIncludeMerger;
import io.agrest.runtime.entity.IMapByMerger;
import io.agrest.runtime.entity.ISizeMerger;
import io.agrest.runtime.entity.ISortMerger;
import io.agrest.runtime.entity.IncludeMerger;
import io.agrest.runtime.entity.MapByMerger;
import io.agrest.runtime.entity.SizeMerger;
import io.agrest.runtime.entity.SortMerger;
import io.agrest.runtime.processor.select.SelectContext;
import io.agrest.runtime.processor.select.stage.SelectCreateResourceEntityStage;
import io.agrest.runtime.protocol.IExcludeParser;
import io.agrest.runtime.protocol.IExpParser;
import io.agrest.runtime.protocol.IIncludeParser;
import io.agrest.runtime.protocol.ISortParser;
import io.agrest.runtime.request.DefaultRequestBuilderFactory;
import io.agrest.runtime.request.IAgRequestBuilderFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.di.Injector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class CreateResourceEntityStageTest {
    private static SelectCreateResourceEntityStage stage;
    private static IAgRequestBuilderFactory requestBuilderFactory;

    @BeforeAll
    public static void beforeAll() {
        AnnotationsAgEntityCompiler compiler = new AnnotationsAgEntityCompiler(Map.of());
        LazySchema schema = new LazySchema(List.of(compiler));
        ExpMerger expMerger = new ExpMerger();
        SortMerger sortMerger = new SortMerger();
        MapByMerger mapByMerger = new MapByMerger((AgSchema)schema);
        SizeMerger sizeMerger = new SizeMerger();
        IncludeMerger includeMerger = new IncludeMerger((AgSchema)schema, (IExpMerger)expMerger, (ISortMerger)sortMerger, (IMapByMerger)mapByMerger, (ISizeMerger)sizeMerger);
        ExcludeMerger excludeMerger = new ExcludeMerger();
        stage = new SelectCreateResourceEntityStage((AgSchema)schema, (IExpMerger)expMerger, (ISortMerger)sortMerger, (IMapByMerger)mapByMerger, (ISizeMerger)sizeMerger, (IIncludeMerger)includeMerger, (IExcludeMerger)excludeMerger);
        requestBuilderFactory = new DefaultRequestBuilderFactory((IExpParser)Mockito.mock(IExpParser.class), (ISortParser)Mockito.mock(ISortParser.class), (IIncludeParser)Mockito.mock(IIncludeParser.class), (IExcludeParser)Mockito.mock(IExcludeParser.class));
    }

    @Test
    public void testExecute_Default() {
        SelectContext context = new SelectContext(Tr.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        context.setRequest(requestBuilderFactory.builder().build());
        context.mergeClientParameters(new HashMap());
        stage.execute(context);
        RootResourceEntity resourceEntity = context.getEntity();
        Assertions.assertNotNull((Object)resourceEntity);
        Assertions.assertTrue((boolean)resourceEntity.isIdIncluded());
        Assertions.assertEquals((int)3, (int)resourceEntity.getBaseProjection().getAttributes().size());
        Assertions.assertTrue((boolean)resourceEntity.getChildren().isEmpty());
    }

    @Test
    public void testExecute_Include() {
        SelectContext context = new SelectContext(Tr.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        context.setRequest(requestBuilderFactory.builder().addInclude(new Include("a")).addInclude(new Include("b")).build());
        stage.execute(context);
        RootResourceEntity resourceEntity = context.getEntity();
        Assertions.assertNotNull((Object)resourceEntity);
        Assertions.assertFalse((boolean)resourceEntity.isIdIncluded());
        Assertions.assertEquals((int)2, (int)resourceEntity.getBaseProjection().getAttributes().size());
        Assertions.assertNotNull((Object)resourceEntity.getBaseProjection().getAttribute("a"));
        Assertions.assertNotNull((Object)resourceEntity.getBaseProjection().getAttribute("b"));
        Assertions.assertTrue((boolean)resourceEntity.getChildren().isEmpty());
    }

    @Test
    public void testExecute_Exclude() {
        SelectContext context = new SelectContext(Tr.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        context.setRequest(requestBuilderFactory.builder().addExclude(new Exclude("a")).addExclude(new Exclude("b")).build());
        stage.execute(context);
        RootResourceEntity resourceEntity = context.getEntity();
        Assertions.assertNotNull((Object)resourceEntity);
        Assertions.assertTrue((boolean)resourceEntity.isIdIncluded());
        Assertions.assertEquals((int)1, (int)resourceEntity.getBaseProjection().getAttributes().size());
        Assertions.assertNotNull((Object)resourceEntity.getBaseProjection().getAttribute("c"));
        Assertions.assertTrue((boolean)resourceEntity.getChildren().isEmpty());
    }

    @Test
    public void testExecute_IncludeExcludeAttrs() {
        SelectContext context = new SelectContext(Tr.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        Include include1 = new Include("a");
        Include include2 = new Include("b");
        Include include3 = new Include("id");
        Exclude exclude1 = new Exclude("a");
        Exclude exclude2 = new Exclude("c");
        context.setRequest(requestBuilderFactory.builder().addInclude(include1).addInclude(include2).addInclude(include3).addExclude(exclude1).addExclude(exclude2).build());
        stage.execute(context);
        RootResourceEntity resourceEntity = context.getEntity();
        Assertions.assertNotNull((Object)resourceEntity);
        Assertions.assertTrue((boolean)resourceEntity.isIdIncluded());
        Assertions.assertEquals((int)1, (int)resourceEntity.getBaseProjection().getAttributes().size());
        Assertions.assertNotNull((Object)resourceEntity.getBaseProjection().getAttribute("b"));
        Assertions.assertTrue((boolean)resourceEntity.getChildren().isEmpty());
    }

    @Test
    public void testExecute_IncludeRels() {
        SelectContext context = new SelectContext(Ts.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        context.setRequest(requestBuilderFactory.builder().addInclude(new Include("rtt")).build());
        stage.execute(context);
        RootResourceEntity resourceEntity = context.getEntity();
        Assertions.assertNotNull((Object)resourceEntity);
        Assertions.assertTrue((boolean)resourceEntity.isIdIncluded());
        Assertions.assertEquals((int)2, (int)resourceEntity.getBaseProjection().getAttributes().size());
        Assertions.assertNotNull((Object)resourceEntity.getBaseProjection().getAttribute("m"));
        Assertions.assertNotNull((Object)resourceEntity.getBaseProjection().getAttribute("n"));
        Assertions.assertEquals((int)1, (int)resourceEntity.getChildren().size());
        Assertions.assertEquals((int)1, (int)resourceEntity.getChildren().size());
        Assertions.assertNotNull((Object)resourceEntity.getChild("rtt"));
        RelatedResourceEntity ttEntity = resourceEntity.getChild("rtt");
        Assertions.assertTrue((boolean)ttEntity.isIdIncluded());
        Assertions.assertEquals((int)2, (int)ttEntity.getBaseProjection().getAttributes().size());
        Assertions.assertNotNull((Object)ttEntity.getBaseProjection().getAttribute("o"));
        Assertions.assertNotNull((Object)ttEntity.getBaseProjection().getAttribute("p"));
        Assertions.assertTrue((boolean)ttEntity.getChildren().isEmpty());
    }

    @Test
    public void testExecute_IncludeBothAttrs() {
        SelectContext context = new SelectContext(Ts.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        context.setRequest(requestBuilderFactory.builder().addInclude(new Include("m")).addInclude(new Include("rtt.o")).build());
        stage.execute(context);
        RootResourceEntity resourceEntity = context.getEntity();
        Assertions.assertNotNull((Object)resourceEntity);
        Assertions.assertFalse((boolean)resourceEntity.isIdIncluded());
        Assertions.assertEquals((int)1, (int)resourceEntity.getBaseProjection().getAttributes().size());
        Assertions.assertNotNull((Object)resourceEntity.getBaseProjection().getAttribute("m"));
        Assertions.assertEquals((int)1, (int)resourceEntity.getChildren().size());
        Assertions.assertEquals((int)1, (int)resourceEntity.getChildren().size());
        Assertions.assertNotNull((Object)resourceEntity.getChild("rtt"));
        RelatedResourceEntity e3ResourceEntity = resourceEntity.getChild("rtt");
        Assertions.assertFalse((boolean)e3ResourceEntity.isIdIncluded());
        Assertions.assertEquals((int)1, (int)e3ResourceEntity.getBaseProjection().getAttributes().size());
        Assertions.assertNotNull((Object)e3ResourceEntity.getBaseProjection().getAttribute("o"));
        Assertions.assertTrue((boolean)e3ResourceEntity.getChildren().isEmpty());
    }

    @Test
    public void testExecute_IncludeExcludeBothAttrs() {
        SelectContext context = new SelectContext(Ts.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        context.setRequest(requestBuilderFactory.builder().addInclude(new Include("rtt.o")).addExclude(new Exclude("m")).build());
        stage.execute(context);
        RootResourceEntity resourceEntity = context.getEntity();
        Assertions.assertNotNull((Object)resourceEntity);
        Assertions.assertTrue((boolean)resourceEntity.isIdIncluded());
        Assertions.assertEquals((int)1, (int)resourceEntity.getBaseProjection().getAttributes().size());
        Assertions.assertNotNull((Object)resourceEntity.getBaseProjection().getAttribute("n"));
        Assertions.assertEquals((int)1, (int)resourceEntity.getChildren().size());
        Assertions.assertEquals((int)1, (int)resourceEntity.getChildren().size());
        Assertions.assertNotNull((Object)resourceEntity.getChild("rtt"));
        RelatedResourceEntity e3ResourceEntity = resourceEntity.getChild("rtt");
        Assertions.assertFalse((boolean)e3ResourceEntity.isIdIncluded());
        Assertions.assertEquals((int)1, (int)e3ResourceEntity.getBaseProjection().getAttributes().size());
        Assertions.assertNotNull((Object)e3ResourceEntity.getBaseProjection().getAttribute("o"));
        Assertions.assertTrue((boolean)e3ResourceEntity.getChildren().isEmpty());
    }

    @Test
    public void testExecute_IncludeExcludeBothAttrs2() {
        SelectContext context = new SelectContext(Ts.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        context.setRequest(requestBuilderFactory.builder().addInclude(new Include("rtt")).addExclude(new Exclude("n")).addExclude(new Exclude("rtt.o")).build());
        stage.execute(context);
        RootResourceEntity resourceEntity = context.getEntity();
        Assertions.assertNotNull((Object)resourceEntity);
        Assertions.assertTrue((boolean)resourceEntity.isIdIncluded());
        Assertions.assertEquals((int)1, (int)resourceEntity.getBaseProjection().getAttributes().size());
        Assertions.assertNotNull((Object)resourceEntity.getBaseProjection().getAttribute("m"));
        Assertions.assertEquals((int)1, (int)resourceEntity.getChildren().size());
        Assertions.assertEquals((int)1, (int)resourceEntity.getChildren().size());
        Assertions.assertNotNull((Object)resourceEntity.getChild("rtt"));
        RelatedResourceEntity e3ResourceEntity = resourceEntity.getChild("rtt");
        Assertions.assertTrue((boolean)e3ResourceEntity.isIdIncluded());
        Assertions.assertEquals((int)1, (int)e3ResourceEntity.getBaseProjection().getAttributes().size());
        Assertions.assertNotNull((Object)e3ResourceEntity.getBaseProjection().getAttribute("p"));
        Assertions.assertTrue((boolean)e3ResourceEntity.getChildren().isEmpty());
    }

    @Test
    public void testExecute_IncludeRelationshipIds() {
        SelectContext context = new SelectContext(Ts.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        context.setRequest(requestBuilderFactory.builder().addInclude(new Include("id")).addInclude(new Include("rtt.id")).build());
        stage.execute(context);
        RootResourceEntity resourceEntity = context.getEntity();
        Assertions.assertNotNull((Object)resourceEntity);
        Assertions.assertTrue((boolean)resourceEntity.isIdIncluded());
        Assertions.assertTrue((boolean)resourceEntity.getBaseProjection().getAttributes().isEmpty());
        Assertions.assertEquals((int)1, (int)resourceEntity.getChildren().size());
        Assertions.assertEquals((int)1, (int)resourceEntity.getChildren().size());
        Assertions.assertNotNull((Object)resourceEntity.getChild("rtt"));
        RelatedResourceEntity e3ResourceEntity = resourceEntity.getChild("rtt");
        Assertions.assertTrue((boolean)e3ResourceEntity.isIdIncluded());
        Assertions.assertTrue((boolean)e3ResourceEntity.getBaseProjection().getAttributes().isEmpty());
        Assertions.assertTrue((boolean)e3ResourceEntity.getChildren().isEmpty());
    }

    @Test
    public void testExecute_SortSimple_NoDir() {
        SelectContext context = new SelectContext(Ts.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        context.setRequest(requestBuilderFactory.builder().addSort(new Sort("n")).build());
        stage.execute(context);
        RootResourceEntity resourceEntity = context.getEntity();
        Assertions.assertEquals((int)1, (int)resourceEntity.getOrderings().size());
        Sort o1 = (Sort)resourceEntity.getOrderings().iterator().next();
        Assertions.assertEquals((Object)new Sort("n", Direction.asc), (Object)o1);
    }

    @Test
    public void testExecute_SortSimple_ASC() {
        SelectContext context = new SelectContext(Ts.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        context.setRequest(requestBuilderFactory.builder().addSort(new Sort("n", Direction.asc)).build());
        stage.execute(context);
        RootResourceEntity resourceEntity = context.getEntity();
        Assertions.assertEquals((int)1, (int)resourceEntity.getOrderings().size());
        Sort o1 = (Sort)resourceEntity.getOrderings().iterator().next();
        Assertions.assertEquals((Object)new Sort("n", Direction.asc), (Object)o1);
    }

    @Test
    public void testExecute_SortSimple_DESC() {
        SelectContext context = new SelectContext(Ts.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        context.setRequest(requestBuilderFactory.builder().addSort(new Sort("n", Direction.desc)).build());
        stage.execute(context);
        RootResourceEntity resourceEntity = context.getEntity();
        Assertions.assertEquals((int)1, (int)resourceEntity.getOrderings().size());
        Sort o1 = (Sort)resourceEntity.getOrderings().iterator().next();
        Assertions.assertEquals((Object)new Sort("n", Direction.desc), (Object)o1);
    }

    @Test
    public void testExecute_Sort() {
        SelectContext context = new SelectContext(Ts.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        context.setRequest(requestBuilderFactory.builder().addSort(new Sort("m", Direction.desc)).addSort(new Sort("n", Direction.asc)).build());
        stage.execute(context);
        RootResourceEntity resourceEntity = context.getEntity();
        Assertions.assertEquals((int)2, (int)resourceEntity.getOrderings().size());
        Assertions.assertEquals((Object)new Sort("m", Direction.desc), resourceEntity.getOrderings().get(0));
        Assertions.assertEquals((Object)new Sort("n", Direction.asc), resourceEntity.getOrderings().get(1));
    }

    @Test
    public void testExecute_Exp_BadSpec() {
        SelectContext context = new SelectContext(Ts.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        context.setRequest(requestBuilderFactory.builder().andExp(Exp.simple((String)"x = 12345 and y = 'John Smith' and z = true")).build());
        Assertions.assertDoesNotThrow(() -> stage.execute(context), (String)"Even though the passed spec is invalid, no parsing should occur at this stage");
    }

    @Test
    public void testExecute_Exp() {
        SelectContext context = new SelectContext(Ts.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        context.setRequest(requestBuilderFactory.builder().andExp(Exp.simple((String)"m = 'John Smith'")).build());
        stage.execute(context);
        RootResourceEntity resourceEntity = context.getEntity();
        Assertions.assertEquals((Object)Exp.simple((String)"m = 'John Smith'"), (Object)resourceEntity.getExp());
    }

    public static class Tt {
        @AgId
        public int getId() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getO() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getP() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Ts {
        @AgId
        public int getId() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getN() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getM() {
            throw new UnsupportedOperationException();
        }

        @AgRelationship
        public Tt getRtt() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Tr {
        @AgId
        public int getId() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public int getA() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getB() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getC() {
            throw new UnsupportedOperationException();
        }

        @AgRelationship
        public List<Ts> getRtss() {
            throw new UnsupportedOperationException();
        }
    }
}

