/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime.processor.select;

import io.agrest.ResourceEntity;
import io.agrest.RootResourceEntity;
import io.agrest.access.PathChecker;
import io.agrest.annotation.AgAttribute;
import io.agrest.annotation.AgId;
import io.agrest.annotation.AgRelationship;
import io.agrest.compiler.AnnotationsAgEntityCompiler;
import io.agrest.meta.AgSchema;
import io.agrest.meta.LazySchema;
import io.agrest.protocol.Include;
import io.agrest.runtime.entity.ExcludeMerger;
import io.agrest.runtime.entity.ExpMerger;
import io.agrest.runtime.entity.IExcludeMerger;
import io.agrest.runtime.entity.IExpMerger;
import io.agrest.runtime.entity.IIncludeMerger;
import io.agrest.runtime.entity.IMapByMerger;
import io.agrest.runtime.entity.ISizeMerger;
import io.agrest.runtime.entity.ISortMerger;
import io.agrest.runtime.entity.IncludeMerger;
import io.agrest.runtime.entity.MapByMerger;
import io.agrest.runtime.entity.SizeMerger;
import io.agrest.runtime.entity.SortMerger;
import io.agrest.runtime.processor.select.SelectContext;
import io.agrest.runtime.processor.select.stage.SelectCreateResourceEntityStage;
import io.agrest.runtime.protocol.IExcludeParser;
import io.agrest.runtime.protocol.IExpParser;
import io.agrest.runtime.protocol.IIncludeParser;
import io.agrest.runtime.protocol.ISortParser;
import io.agrest.runtime.request.DefaultRequestBuilderFactory;
import io.agrest.runtime.request.IAgRequestBuilderFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.di.Injector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class CreateResourceEntityStage_IncludeObjectTest {
    private static SelectCreateResourceEntityStage stage;
    private static IAgRequestBuilderFactory requestBuilderFactory;

    @BeforeAll
    public static void beforeAll() {
        AnnotationsAgEntityCompiler compiler = new AnnotationsAgEntityCompiler(Map.of());
        LazySchema schema = new LazySchema(List.of(compiler));
        ExpMerger expConstructor = new ExpMerger();
        SortMerger sortConstructor = new SortMerger();
        MapByMerger mapByConstructor = new MapByMerger((AgSchema)schema);
        SizeMerger sizeConstructor = new SizeMerger();
        IncludeMerger includeConstructor = new IncludeMerger((AgSchema)schema, (IExpMerger)expConstructor, (ISortMerger)sortConstructor, (IMapByMerger)mapByConstructor, (ISizeMerger)sizeConstructor);
        ExcludeMerger excludeConstructor = new ExcludeMerger();
        stage = new SelectCreateResourceEntityStage((AgSchema)schema, (IExpMerger)expConstructor, (ISortMerger)sortConstructor, (IMapByMerger)mapByConstructor, (ISizeMerger)sizeConstructor, (IIncludeMerger)includeConstructor, (IExcludeMerger)excludeConstructor);
        requestBuilderFactory = new DefaultRequestBuilderFactory((IExpParser)Mockito.mock(IExpParser.class), (ISortParser)Mockito.mock(ISortParser.class), (IIncludeParser)Mockito.mock(IIncludeParser.class), (IExcludeParser)Mockito.mock(IExcludeParser.class));
    }

    @Test
    public void testExecute_IncludeObject_Path() {
        SelectContext context = new SelectContext(Tr.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        context.setRequest(requestBuilderFactory.builder().addInclude(new Include("rtss")).build());
        stage.execute(context);
        RootResourceEntity resourceEntity = context.getEntity();
        Assertions.assertNotNull((Object)resourceEntity);
        Assertions.assertTrue((boolean)resourceEntity.isIdIncluded());
        Assertions.assertEquals((int)1, (int)resourceEntity.getChildren().size());
        Assertions.assertNotNull((Object)resourceEntity.getChild("rtss"));
    }

    @Test
    public void testExecute_IncludeObject_MapBy() {
        SelectContext context = new SelectContext(Tr.class, requestBuilderFactory.builder(), PathChecker.ofDefault(), (Injector)Mockito.mock(Injector.class));
        Include include = new Include("rtss", null, Collections.emptyList(), "rtt", null, null);
        context.setRequest(requestBuilderFactory.builder().addInclude(include).build());
        stage.execute(context);
        RootResourceEntity resourceEntity = context.getEntity();
        Assertions.assertNotNull((Object)resourceEntity);
        ResourceEntity reMapBy = resourceEntity.getChild("rtss").getMapBy();
        Assertions.assertNotNull((Object)reMapBy);
        Assertions.assertNotNull((Object)reMapBy.getChild("rtt"));
    }

    public static class Tt {
        @AgId
        public int getId() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Ts {
        @AgId
        public int getId() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getN() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getM() {
            throw new UnsupportedOperationException();
        }

        @AgRelationship
        public Tt getRtt() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Tr {
        @AgId
        public int getId() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public int getA() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getB() {
            throw new UnsupportedOperationException();
        }

        @AgRelationship
        public List<Ts> getRtss() {
            throw new UnsupportedOperationException();
        }
    }
}

