/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime.protocol;

import io.agrest.exp.parser.ExpRoot;
import io.agrest.runtime.jackson.IJacksonService;
import io.agrest.runtime.jackson.JacksonService;
import io.agrest.runtime.protocol.ExpParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ExpParserTest {
    private static ExpParser parser;

    @BeforeAll
    public static void beforeAll() {
        parser = new ExpParser((IJacksonService)JacksonService.create());
    }

    @Test
    public void testProcess_Bare() {
        ExpRoot exp = (ExpRoot)parser.fromString("a = 12345 and b = 'John Smith' and c = true");
        Assertions.assertNotNull((Object)exp);
        Assertions.assertEquals((Object)"a = 12345 and b = 'John Smith' and c = true", (Object)exp.getTemplate());
    }

    @Test
    public void testProcess_Functions() {
        ExpRoot exp = (ExpRoot)parser.fromString("length(b) > 5");
        Assertions.assertNotNull((Object)exp);
        Assertions.assertEquals((Object)"length(b) > 5", (Object)exp.getTemplate());
    }

    @Test
    public void testProcess_List() {
        ExpRoot exp = (ExpRoot)parser.fromString("[\"a = 12345 and b = 'John Smith' and c = true\"]");
        Assertions.assertNotNull((Object)exp);
        Assertions.assertEquals((Object)"a = 12345 and b = 'John Smith' and c = true", (Object)exp.getTemplate());
    }

    @Test
    public void testProcess_List_Params_String() {
        ExpRoot exp = (ExpRoot)parser.fromString("[\"b=$s\",\"x\"]");
        Assertions.assertNotNull((Object)exp);
        Assertions.assertEquals((Object)"b=$s", (Object)exp.getTemplate());
        Assertions.assertEquals((int)1, (int)exp.getPositionalParams().length);
        Assertions.assertEquals((Object)"\"x\"", (Object)exp.getPositionalParams()[0].toString());
    }

    @Test
    public void testProcess_List_Params_Multiple() {
        ExpRoot exp = (ExpRoot)parser.fromString("[\"b=$s or b =$x or b =$s\",\"x\",\"y\"]");
        Assertions.assertNotNull((Object)exp);
        Assertions.assertEquals((Object)"b=$s or b =$x or b =$s", (Object)exp.getTemplate());
        Assertions.assertEquals((int)2, (int)exp.getPositionalParams().length);
        Assertions.assertEquals((Object)"\"x\"", (Object)exp.getPositionalParams()[0].toString());
        Assertions.assertEquals((Object)"\"y\"", (Object)exp.getPositionalParams()[1].toString());
    }

    @Test
    public void testProcess_Map() {
        ExpRoot exp = (ExpRoot)parser.fromString("{\"exp\" : \"a = 12345 and b = 'John Smith' and c = true\"}");
        Assertions.assertNotNull((Object)exp);
        Assertions.assertEquals((Object)"a = 12345 and b = 'John Smith' and c = true", (Object)exp.getTemplate());
    }

    @Test
    public void testProcess_Map_Params_String() {
        ExpRoot exp = (ExpRoot)parser.fromString("{\"exp\" : \"b=$s\", \"params\":{\"s\":\"x\"}}");
        Assertions.assertNotNull((Object)exp);
        Assertions.assertEquals((Object)"b=$s", (Object)exp.getTemplate());
        Assertions.assertFalse((boolean)exp.getNamedParams().isEmpty());
        Assertions.assertEquals((Object)"\"x\"", (Object)exp.getNamedParams().get("s").toString());
    }

    @Test
    public void testProcess_Map_Params_Null() {
        ExpRoot exp = (ExpRoot)parser.fromString("{\"exp\" : \"c=$b\", \"params\":{\"b\": null}}");
        Assertions.assertNotNull((Object)exp);
        Assertions.assertEquals((Object)"c=$b", (Object)exp.getTemplate());
        Assertions.assertFalse((boolean)exp.getNamedParams().isEmpty());
        Assertions.assertNull(exp.getNamedParams().get("b"));
    }
}

