/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime.protocol;

import io.agrest.ResourceEntity;
import io.agrest.RootResourceEntity;
import io.agrest.access.PathChecker;
import io.agrest.annotation.AgAttribute;
import io.agrest.annotation.AgId;
import io.agrest.compiler.AnnotationsAgEntityCompiler;
import io.agrest.meta.AgSchema;
import io.agrest.meta.LazySchema;
import io.agrest.protocol.Direction;
import io.agrest.protocol.Sort;
import io.agrest.runtime.entity.SortMerger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SortMergerTest {
    private static SortMerger merger;
    private static AgSchema schema;
    private ResourceEntity<?> entity;

    @BeforeAll
    public static void beforeAll() {
        AnnotationsAgEntityCompiler compiler = new AnnotationsAgEntityCompiler(Map.of());
        schema = new LazySchema(List.of(compiler));
        merger = new SortMerger();
    }

    @BeforeEach
    public void beforeEach() {
        this.entity = new RootResourceEntity(schema.getEntity(Tr.class));
    }

    @Test
    public void testMerge_Array() {
        merger.merge(this.entity, Arrays.asList(new Sort("a"), new Sort("b")), PathChecker.ofDefault());
        Assertions.assertEquals((int)2, (int)this.entity.getOrderings().size());
        Assertions.assertEquals((Object)new Sort("a", Direction.asc), this.entity.getOrderings().get(0));
        Assertions.assertEquals((Object)new Sort("b", Direction.asc), this.entity.getOrderings().get(1));
    }

    @Test
    public void testMerge_Simple() {
        merger.merge(this.entity, List.of(new Sort("a")), PathChecker.ofDefault());
        Assertions.assertEquals((int)1, (int)this.entity.getOrderings().size());
        Assertions.assertEquals((Object)new Sort("a", Direction.asc), this.entity.getOrderings().get(0));
    }

    public static class Tr {
        @AgId
        public int getId() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public int getA() {
            throw new UnsupportedOperationException();
        }

        @AgAttribute
        public String getB() {
            throw new UnsupportedOperationException();
        }
    }
}

