/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime.protocol;

import io.agrest.protocol.Direction;
import io.agrest.protocol.Sort;
import io.agrest.runtime.jackson.IJacksonService;
import io.agrest.runtime.jackson.JacksonService;
import io.agrest.runtime.protocol.SortParser;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SortParserTest {
    private static SortParser parser;

    @BeforeAll
    public static void beforeAll() {
        parser = new SortParser((IJacksonService)JacksonService.create());
    }

    @Test
    public void testProcess_Array() {
        List orderings = parser.parse("[{\"path\":\"name\"},{\"path\":\"address\",\"direction\":\"ASC\"},{\"path\":\"city\",\"direction\":\"DESC_CI\"}]", null);
        Assertions.assertNotNull((Object)orderings);
        Assertions.assertEquals((int)3, (int)orderings.size());
        Assertions.assertEquals((Object)"name", (Object)((Sort)orderings.get(0)).getPath());
        Assertions.assertEquals((Object)Direction.asc, (Object)((Sort)orderings.get(0)).getDirection());
        Assertions.assertEquals((Object)"address", (Object)((Sort)orderings.get(1)).getPath());
        Assertions.assertEquals((Object)Direction.asc, (Object)((Sort)orderings.get(1)).getDirection());
        Assertions.assertEquals((Object)"city", (Object)((Sort)orderings.get(2)).getPath());
        Assertions.assertEquals((Object)Direction.desc_ci, (Object)((Sort)orderings.get(2)).getDirection());
    }

    @Test
    public void testProcess_Object() {
        List orderings = parser.parse("{\"path\":\"name\"}", null);
        Assertions.assertEquals((int)1, (int)orderings.size());
        Assertions.assertEquals((Object)"name", (Object)((Sort)orderings.get(0)).getPath());
        Assertions.assertEquals((Object)Direction.asc, (Object)((Sort)orderings.get(0)).getDirection());
    }

    @Test
    public void testProcess_Simple() {
        List orderings = parser.parse("name", null);
        Assertions.assertEquals((int)1, (int)orderings.size());
        Assertions.assertEquals((Object)"name", (Object)((Sort)orderings.get(0)).getPath());
        Assertions.assertEquals((Object)Direction.asc, (Object)((Sort)orderings.get(0)).getDirection());
    }

    @Test
    public void testProcess_Simple_ASC() {
        List orderings = parser.parse("name", "ASC");
        Assertions.assertEquals((int)1, (int)orderings.size());
        Assertions.assertEquals((Object)"name", (Object)((Sort)orderings.get(0)).getPath());
        Assertions.assertEquals((Object)Direction.asc, (Object)((Sort)orderings.get(0)).getDirection());
    }

    @Test
    public void testProcess_Simple_DESC() {
        List orderings = parser.parse("name", "DESC");
        Assertions.assertEquals((int)1, (int)orderings.size());
        Assertions.assertEquals((Object)"name", (Object)((Sort)orderings.get(0)).getPath());
        Assertions.assertEquals((Object)Direction.desc, (Object)((Sort)orderings.get(0)).getDirection());
    }

    @Test
    public void testProcess_Simple_ASC_INSENSITIVE() {
        List orderings = parser.parse("name", "ASC_CI");
        Assertions.assertEquals((int)1, (int)orderings.size());
        Assertions.assertEquals((Object)"name", (Object)((Sort)orderings.get(0)).getPath());
        Assertions.assertEquals((Object)Direction.asc_ci, (Object)((Sort)orderings.get(0)).getDirection());
    }

    @Test
    public void testProcess_Simple_DESC_INSENSITIVE() {
        List orderings = parser.parse("name", "DESC_CI");
        Assertions.assertEquals((int)1, (int)orderings.size());
        Assertions.assertEquals((Object)"name", (Object)((Sort)orderings.get(0)).getPath());
        Assertions.assertEquals((Object)Direction.desc_ci, (Object)((Sort)orderings.get(0)).getDirection());
    }
}

