/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime.request;

import io.agrest.AgException;
import io.agrest.AgRequest;
import io.agrest.exp.parser.ExpRoot;
import io.agrest.protocol.Direction;
import io.agrest.protocol.Exclude;
import io.agrest.protocol.Include;
import io.agrest.protocol.Sort;
import io.agrest.runtime.jackson.IJacksonService;
import io.agrest.runtime.jackson.JacksonService;
import io.agrest.runtime.protocol.ExcludeParser;
import io.agrest.runtime.protocol.ExpParser;
import io.agrest.runtime.protocol.IExcludeParser;
import io.agrest.runtime.protocol.IExpParser;
import io.agrest.runtime.protocol.IIncludeParser;
import io.agrest.runtime.protocol.ISizeParser;
import io.agrest.runtime.protocol.ISortParser;
import io.agrest.runtime.protocol.IncludeParser;
import io.agrest.runtime.protocol.SizeParser;
import io.agrest.runtime.protocol.SortParser;
import io.agrest.runtime.request.DefaultRequestBuilder;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultRequestBuilderTest {
    DefaultRequestBuilder builder;

    @BeforeEach
    public void beforeEach() {
        JacksonService jacksonService = JacksonService.create();
        ExpParser expParser = new ExpParser((IJacksonService)jacksonService);
        SortParser sortParser = new SortParser((IJacksonService)jacksonService);
        SizeParser sizeParser = new SizeParser();
        IncludeParser includeParser = new IncludeParser((IJacksonService)jacksonService, (IExpParser)expParser, (ISortParser)sortParser, (ISizeParser)sizeParser);
        ExcludeParser excludeParser = new ExcludeParser((IJacksonService)jacksonService);
        this.builder = new DefaultRequestBuilder((IExpParser)expParser, (ISortParser)sortParser, (IIncludeParser)includeParser, (IExcludeParser)excludeParser);
    }

    @Test
    public void testBuild_Defaults() {
        AgRequest request = this.builder.build();
        Assertions.assertNotNull((Object)request);
        Assertions.assertNull((Object)request.getExp());
        Assertions.assertTrue((boolean)request.getSorts().isEmpty());
        Assertions.assertNull((Object)request.getMapBy());
        Assertions.assertNull((Object)request.getLimit());
        Assertions.assertNull((Object)request.getStart());
        Assertions.assertTrue((boolean)request.getIncludes().isEmpty());
        Assertions.assertTrue((boolean)request.getExcludes().isEmpty());
    }

    @Test
    public void testBuild_Include() {
        Map<String, List<String>> params = Map.of("include", List.of("a", "b"));
        AgRequest request = this.builder.mergeClientParams(params).build();
        Assertions.assertEquals((int)2, (int)request.getIncludes().size());
        Assertions.assertEquals((Object)"a", (Object)((Include)request.getIncludes().get(0)).getPath());
        Assertions.assertEquals((Object)"b", (Object)((Include)request.getIncludes().get(1)).getPath());
    }

    @Test
    public void testBuild_Include_Array() {
        Map<String, List<String>> params = Map.of("include", List.of("[\"a\", \"b\"]"));
        AgRequest request = this.builder.mergeClientParams(params).build();
        Assertions.assertEquals((int)2, (int)request.getIncludes().size());
        Assertions.assertEquals((Object)"a", (Object)((Include)request.getIncludes().get(0)).getPath());
        Assertions.assertEquals((Object)"b", (Object)((Include)request.getIncludes().get(1)).getPath());
    }

    @Test
    public void testBuild_Exclude() {
        Map<String, List<String>> params = Map.of("exclude", List.of("a", "b"));
        AgRequest request = this.builder.mergeClientParams(params).build();
        Assertions.assertEquals((int)2, (int)request.getExcludes().size());
        Assertions.assertEquals((Object)"a", (Object)((Exclude)request.getExcludes().get(0)).getPath());
        Assertions.assertEquals((Object)"b", (Object)((Exclude)request.getExcludes().get(1)).getPath());
    }

    @Test
    public void testBuild_Exclude_Array() {
        Map<String, List<String>> params = Map.of("exclude", List.of("[\"a\", \"b\"]"));
        AgRequest request = this.builder.mergeClientParams(params).build();
        Assertions.assertEquals((int)2, (int)request.getExcludes().size());
        Assertions.assertEquals((Object)"a", (Object)((Exclude)request.getExcludes().get(0)).getPath());
        Assertions.assertEquals((Object)"b", (Object)((Exclude)request.getExcludes().get(1)).getPath());
    }

    @Test
    public void testBuild_IncludeExclude() {
        Map<String, List<String>> params = Map.of("include", List.of("a", "b", "id"), "exclude", List.of("a", "c"));
        AgRequest request = this.builder.mergeClientParams(params).build();
        Assertions.assertEquals((int)3, (int)request.getIncludes().size());
        Assertions.assertEquals((Object)"a", (Object)((Include)request.getIncludes().get(0)).getPath());
        Assertions.assertEquals((Object)"b", (Object)((Include)request.getIncludes().get(1)).getPath());
        Assertions.assertEquals((Object)"id", (Object)((Include)request.getIncludes().get(2)).getPath());
        Assertions.assertEquals((int)2, (int)request.getExcludes().size());
        Assertions.assertEquals((Object)"a", (Object)((Exclude)request.getExcludes().get(0)).getPath());
        Assertions.assertEquals((Object)"c", (Object)((Exclude)request.getExcludes().get(1)).getPath());
    }

    @Test
    public void testBuild_IncludeRels() {
        Map<String, List<String>> params = Map.of("include", List.of("rtss"));
        AgRequest request = this.builder.mergeClientParams(params).build();
        Assertions.assertEquals((int)1, (int)request.getIncludes().size());
        Assertions.assertEquals((Object)"rtss", (Object)((Include)request.getIncludes().get(0)).getPath());
    }

    @Test
    public void testBuild_SortSimple_NoDir() {
        Map<String, List<String>> params = Map.of("sort", List.of("rtss"));
        AgRequest request = this.builder.mergeClientParams(params).build();
        Assertions.assertNotNull((Object)request.getSorts());
        Sort ordering = (Sort)request.getSorts().get(0);
        Assertions.assertEquals((Object)"rtss", (Object)ordering.getPath());
    }

    @Test
    public void testBuild_SortSimple_ASC() {
        Map<String, List<String>> params = Map.of("sort", List.of("rtss"), "direction", List.of("ASC"));
        AgRequest request = this.builder.mergeClientParams(params).build();
        Assertions.assertNotNull((Object)request.getSorts());
        Assertions.assertEquals((int)1, (int)request.getSorts().size());
        Sort ordering = (Sort)request.getSorts().get(0);
        Assertions.assertEquals((Object)"rtss", (Object)ordering.getPath());
        Assertions.assertEquals((Object)Direction.asc, (Object)ordering.getDirection());
    }

    @Test
    public void testBuild_SortSimple_DESC() {
        Map<String, List<String>> params = Map.of("sort", List.of("rtss"), "direction", List.of("DESC"));
        AgRequest request = this.builder.mergeClientParams(params).build();
        Assertions.assertNotNull((Object)request.getSorts());
        Sort ordering = (Sort)request.getSorts().get(0);
        Assertions.assertEquals((Object)"rtss", (Object)ordering.getPath());
        Assertions.assertEquals((Object)Direction.desc, (Object)ordering.getDirection());
    }

    @Test
    public void testBuild_SortSimple_Garbage() {
        Map<String, List<String>> params = Map.of("sort", List.of("xx"), "direction", List.of("XYZ"));
        Assertions.assertThrows(AgException.class, () -> this.builder.mergeClientParams(params).build());
    }

    @Test
    public void testBuild_Sort() {
        Map<String, List<String>> params = Map.of("sort", List.of("[{\"path\":\"a\",\"direction\":\"DESC\"},{\"path\":\"b\",\"direction\":\"ASC\"}]"));
        AgRequest request = this.builder.mergeClientParams(params).build();
        Assertions.assertNotNull((Object)request.getSorts());
        Assertions.assertEquals((int)2, (int)request.getSorts().size());
        Sort o1 = (Sort)request.getSorts().get(0);
        Sort o2 = (Sort)request.getSorts().get(1);
        Assertions.assertEquals((Object)"a", (Object)o1.getPath());
        Assertions.assertEquals((Object)Direction.desc, (Object)o1.getDirection());
        Assertions.assertEquals((Object)"b", (Object)o2.getPath());
        Assertions.assertEquals((Object)Direction.asc, (Object)o2.getDirection());
    }

    @Test
    public void testBuild_Sort_Dupes() {
        Map<String, List<String>> params = Map.of("sort", List.of("[{\"path\":\"a\",\"direction\":\"DESC\"},{\"path\":\"a\",\"direction\":\"ASC\"}]"));
        AgRequest request = this.builder.mergeClientParams(params).build();
        Assertions.assertNotNull((Object)request.getSorts());
        Assertions.assertEquals((int)2, (int)request.getSorts().size());
        Sort o1 = (Sort)request.getSorts().get(0);
        Sort o2 = (Sort)request.getSorts().get(1);
        Assertions.assertEquals((Object)"a", (Object)o1.getPath());
        Assertions.assertEquals((Object)Direction.desc, (Object)o1.getDirection());
        Assertions.assertEquals((Object)"a", (Object)o2.getPath());
        Assertions.assertEquals((Object)Direction.asc, (Object)o2.getDirection());
    }

    @Test
    public void testBuild_Sort_BadSpec() {
        Map<String, List<String>> params = Map.of("sort", List.of("[{\"path\":\"p1\",\"direction\":\"DESC\"},{\"path\":\"p2\",\"direction\":\"XXX\"}]"));
        Assertions.assertThrows(AgException.class, () -> this.builder.mergeClientParams(params).build());
    }

    @Test
    public void testBuild_Exp_BadSpec() {
        Map<String, List<String>> params = Map.of("exp", List.of("{exp : \"numericProp = 12345 and stringProp = 'John Smith' and booleanProp = true\"}"));
        Assertions.assertThrows(AgException.class, () -> this.builder.mergeClientParams(params).build());
    }

    @Test
    public void testBuild_Exp() {
        Map<String, List<String>> params = Map.of("exp", List.of("{\"exp\" : \"a = 'John Smith'\"}"));
        AgRequest request = this.builder.mergeClientParams(params).build();
        Assertions.assertNotNull((Object)request.getExp());
        Assertions.assertEquals((Object)"a = 'John Smith'", (Object)((ExpRoot)request.getExp()).getTemplate());
    }
}

