/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.runtime.request;

import io.agrest.AgRequest;
import io.agrest.protocol.Include;
import io.agrest.runtime.jackson.IJacksonService;
import io.agrest.runtime.jackson.JacksonService;
import io.agrest.runtime.protocol.ExcludeParser;
import io.agrest.runtime.protocol.ExpParser;
import io.agrest.runtime.protocol.IExcludeParser;
import io.agrest.runtime.protocol.IExpParser;
import io.agrest.runtime.protocol.IIncludeParser;
import io.agrest.runtime.protocol.ISizeParser;
import io.agrest.runtime.protocol.ISortParser;
import io.agrest.runtime.protocol.IncludeParser;
import io.agrest.runtime.protocol.SizeParser;
import io.agrest.runtime.protocol.SortParser;
import io.agrest.runtime.request.DefaultRequestBuilder;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultRequestBuilder_IncludeObjectTest {
    DefaultRequestBuilder builder;

    @BeforeEach
    public void beforeEach() {
        JacksonService jacksonService = JacksonService.create();
        ExpParser expParser = new ExpParser((IJacksonService)jacksonService);
        SortParser sortParser = new SortParser((IJacksonService)jacksonService);
        SizeParser sizeParser = new SizeParser();
        IncludeParser includeParser = new IncludeParser((IJacksonService)jacksonService, (IExpParser)expParser, (ISortParser)sortParser, (ISizeParser)sizeParser);
        ExcludeParser excludeParser = new ExcludeParser((IJacksonService)jacksonService);
        this.builder = new DefaultRequestBuilder((IExpParser)expParser, (ISortParser)sortParser, (IIncludeParser)includeParser, (IExcludeParser)excludeParser);
    }

    @Test
    public void testExecute_IncludeObject_Path() {
        Map<String, List<String>> params = Map.of("include", List.of("{\"path\":\"rtt\"}"));
        AgRequest request = this.builder.mergeClientParams(params).build();
        Assertions.assertEquals((int)1, (int)request.getIncludes().size());
        Assertions.assertEquals((Object)"rtt", (Object)((Include)request.getIncludes().get(0)).getPath());
    }

    @Test
    public void testExecute_IncludeObject_MapBy() {
        Map<String, List<String>> params = Map.of("include", List.of("{\"path\":\"rtt\",\"mapBy\":\"rtu\"}"));
        AgRequest request = this.builder.mergeClientParams(params).build();
        Assertions.assertEquals((int)1, (int)request.getIncludes().size());
        Assertions.assertTrue((boolean)((Include)request.getIncludes().get(0)).getPath().equalsIgnoreCase("rtt"));
        Assertions.assertTrue((boolean)((Include)request.getIncludes().get(0)).getMapBy().equalsIgnoreCase("rtu"));
    }
}

