/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.docs;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Map;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.Postprocessor;
import org.jsoup.Jsoup;

public class AgrestPostprocessor
extends Postprocessor {
    private static final String FRONT_MATTER = "front-matter";
    private static final String EMPTY_FRONT_MATTER = "---\n---\n\n";

    public String process(Document document, String output) {
        output = this.extractTableOfContents(document, output);
        output = this.processHeader(document, output);
        return output;
    }

    protected String processHeader(Document document, String output) {
        String headerFile = (String)document.getAttribute((Object)"agrest-header", (Object)"");
        if (headerFile.isEmpty()) {
            return output;
        }
        String header = FRONT_MATTER.equals(headerFile.trim()) ? EMPTY_FRONT_MATTER : document.readAsset(headerFile, Collections.emptyMap());
        return header + output;
    }

    protected String extractTableOfContents(Document document, String output) {
        int start = output.indexOf("<div id=\"toc\" class=\"toc\">");
        if (start == -1) {
            return output;
        }
        String tocEndString = "</ul>\n</div>";
        int end = output.indexOf(tocEndString, start);
        if (end == -1) {
            return output;
        }
        org.jsoup.nodes.Document tocDoc = Jsoup.parseBodyFragment((String)output.substring(start, end += tocEndString.length() + 1));
        tocDoc.select("ul").addClass("nav");
        tocDoc.select("a").addClass("nav-link");
        tocDoc.select("div#toc").addClass("toc-side");
        String toc = tocDoc.body().html();
        Object destDir = document.getOptions().get("destination_dir");
        Object docname = ((Map)document.getOptions().get("attributes")).get("docname");
        Path path = FileSystems.getDefault().getPath((String)destDir, docname + ".toc.html");
        OpenOption[] options = new StandardOpenOption[]{StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE};
        try (BufferedWriter br = Files.newBufferedWriter(path, options);){
            br.write(toc, 0, toc.length());
            br.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        if (start == 0) {
            return output.substring(end);
        }
        return output.substring(0, start) + output.substring(end);
    }
}

