/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.concurrent;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.ExtendedSettableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestExtendedSettableFuture {
    @Test
    public void testSet() throws Exception {
        ExtendedSettableFuture future = ExtendedSettableFuture.create();
        future.set((Object)"abc");
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCancelled());
        Assert.assertFalse((boolean)future.checkWasInterrupted());
        Assert.assertEquals((String)((String)future.get()), (String)"abc");
    }

    @Test
    public void testSetException() throws Exception {
        ExtendedSettableFuture future = ExtendedSettableFuture.create();
        future.setException((Throwable)new Exception(""));
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCancelled());
        Assert.assertFalse((boolean)future.checkWasInterrupted());
        Assert.assertThrows(ExecutionException.class, () -> ((ExtendedSettableFuture)future).get());
    }

    @Test
    public void testCancelWithoutInterrupt() throws Exception {
        ExtendedSettableFuture future = ExtendedSettableFuture.create();
        future.cancel(false);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.isCancelled());
        Assert.assertFalse((boolean)future.checkWasInterrupted());
        Assert.assertThrows(CancellationException.class, () -> ((ExtendedSettableFuture)future).get());
    }

    @Test
    public void testCancelWithInterrupt() throws Exception {
        ExtendedSettableFuture future = ExtendedSettableFuture.create();
        future.cancel(true);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.isCancelled());
        Assert.assertTrue((boolean)future.checkWasInterrupted());
        Assert.assertThrows(CancellationException.class, () -> ((ExtendedSettableFuture)future).get());
    }

    @Test
    public void testSetAsync() throws Exception {
        ExtendedSettableFuture fromFuture = ExtendedSettableFuture.create();
        ExtendedSettableFuture toFuture = ExtendedSettableFuture.create();
        toFuture.setAsync((ListenableFuture)fromFuture);
        fromFuture.set((Object)"abc");
        Assert.assertEquals((String)((String)toFuture.get()), (String)"abc");
        fromFuture = ExtendedSettableFuture.create();
        toFuture = ExtendedSettableFuture.create();
        toFuture.setAsync((ListenableFuture)fromFuture);
        fromFuture.setException((Throwable)new RuntimeException());
        Assert.assertThrows(ExecutionException.class, () -> ((ExtendedSettableFuture)toFuture).get());
        fromFuture = ExtendedSettableFuture.create();
        toFuture = ExtendedSettableFuture.create();
        toFuture.setAsync((ListenableFuture)fromFuture);
        toFuture.cancel(false);
        Assert.assertTrue((boolean)fromFuture.isCancelled());
        Assert.assertFalse((boolean)fromFuture.checkWasInterrupted());
        fromFuture = ExtendedSettableFuture.create();
        toFuture = ExtendedSettableFuture.create();
        toFuture.setAsync((ListenableFuture)fromFuture);
        toFuture.cancel(true);
        Assert.assertTrue((boolean)fromFuture.isCancelled());
        Assert.assertTrue((boolean)fromFuture.checkWasInterrupted());
    }
}

