/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.concurrent;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.ExtendedSettableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExtendedSettableFuture {
    @Test
    public void testSet() throws Exception {
        ExtendedSettableFuture future = ExtendedSettableFuture.create();
        future.set((Object)"abc");
        Assertions.assertThat((Future)future).isDone();
        Assertions.assertThat((Future)future).isNotCancelled();
        Assertions.assertThat((boolean)future.checkWasInterrupted()).isFalse();
        Assertions.assertThat((String)((String)future.get())).isEqualTo("abc");
    }

    @Test
    public void testSetException() {
        ExtendedSettableFuture future = ExtendedSettableFuture.create();
        future.setException((Throwable)new Exception(""));
        Assertions.assertThat((Future)future).isDone();
        Assertions.assertThat((Future)future).isNotCancelled();
        Assertions.assertThat((boolean)future.checkWasInterrupted()).isFalse();
        Assertions.assertThatThrownBy(() -> ((ExtendedSettableFuture)future).get()).isInstanceOf(ExecutionException.class);
    }

    @Test
    public void testCancelWithoutInterrupt() {
        ExtendedSettableFuture future = ExtendedSettableFuture.create();
        future.cancel(false);
        Assertions.assertThat((Future)future).isDone();
        Assertions.assertThat((Future)future).isCancelled();
        Assertions.assertThat((boolean)future.checkWasInterrupted()).isFalse();
        Assertions.assertThatThrownBy(() -> ((ExtendedSettableFuture)future).get()).isInstanceOf(CancellationException.class);
    }

    @Test
    public void testCancelWithInterrupt() {
        ExtendedSettableFuture future = ExtendedSettableFuture.create();
        future.cancel(true);
        Assertions.assertThat((Future)future).isDone();
        Assertions.assertThat((Future)future).isCancelled();
        Assertions.assertThat((boolean)future.checkWasInterrupted()).isTrue();
        Assertions.assertThatThrownBy(() -> ((ExtendedSettableFuture)future).get()).isInstanceOf(CancellationException.class);
    }

    @Test
    public void testSetAsync() throws Exception {
        ExtendedSettableFuture fromFuture = ExtendedSettableFuture.create();
        ExtendedSettableFuture toFuture = ExtendedSettableFuture.create();
        toFuture.setAsync((ListenableFuture)fromFuture);
        fromFuture.set((Object)"abc");
        Assertions.assertThat((String)((String)toFuture.get())).isEqualTo("abc");
        fromFuture = ExtendedSettableFuture.create();
        toFuture = ExtendedSettableFuture.create();
        toFuture.setAsync((ListenableFuture)fromFuture);
        fromFuture.setException((Throwable)new RuntimeException());
        Assertions.assertThatThrownBy(() -> ((ExtendedSettableFuture)toFuture).get()).isInstanceOf(ExecutionException.class);
        fromFuture = ExtendedSettableFuture.create();
        toFuture = ExtendedSettableFuture.create();
        toFuture.setAsync((ListenableFuture)fromFuture);
        toFuture.cancel(false);
        Assertions.assertThat((Future)fromFuture).isCancelled();
        Assertions.assertThat((boolean)fromFuture.checkWasInterrupted()).isFalse();
        fromFuture = ExtendedSettableFuture.create();
        toFuture = ExtendedSettableFuture.create();
        toFuture.setAsync((ListenableFuture)fromFuture);
        toFuture.cancel(true);
        Assertions.assertThat((Future)fromFuture).isCancelled();
        Assertions.assertThat((boolean)fromFuture.checkWasInterrupted()).isTrue();
    }
}

