/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.concurrent;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.ExtendedSettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestMoreFutures {
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"test-%s"));

    @AfterAll
    public void tearDown() {
        this.executorService.shutdownNow();
    }

    @Test
    public void propagateCancellationWithoutInterrupt() {
        ExtendedSettableFuture fromFuture = ExtendedSettableFuture.create();
        ExtendedSettableFuture toFuture = ExtendedSettableFuture.create();
        MoreFutures.propagateCancellation((ListenableFuture)fromFuture, (Future)toFuture, (boolean)false);
        fromFuture.cancel(true);
        Assertions.assertThat((Future)toFuture).isCancelled();
        Assertions.assertThat((boolean)toFuture.checkWasInterrupted()).isFalse();
        fromFuture = ExtendedSettableFuture.create();
        toFuture = ExtendedSettableFuture.create();
        MoreFutures.propagateCancellation((ListenableFuture)fromFuture, (Future)toFuture, (boolean)false);
        fromFuture.cancel(false);
        Assertions.assertThat((Future)toFuture).isCancelled();
        Assertions.assertThat((boolean)toFuture.checkWasInterrupted()).isFalse();
    }

    @Test
    public void propagateCancellationWithInterrupt() {
        ExtendedSettableFuture fromFuture = ExtendedSettableFuture.create();
        ExtendedSettableFuture toFuture = ExtendedSettableFuture.create();
        MoreFutures.propagateCancellation((ListenableFuture)fromFuture, (Future)toFuture, (boolean)true);
        fromFuture.cancel(true);
        Assertions.assertThat((Future)toFuture).isCancelled();
        Assertions.assertThat((boolean)toFuture.checkWasInterrupted()).isTrue();
        fromFuture = ExtendedSettableFuture.create();
        toFuture = ExtendedSettableFuture.create();
        MoreFutures.propagateCancellation((ListenableFuture)fromFuture, (Future)toFuture, (boolean)true);
        fromFuture.cancel(false);
        Assertions.assertThat((Future)toFuture).isCancelled();
        Assertions.assertThat((boolean)toFuture.checkWasInterrupted()).isTrue();
    }

    @Test
    public void testMirror() throws Exception {
        ExtendedSettableFuture fromFuture = ExtendedSettableFuture.create();
        SettableFuture toFuture = SettableFuture.create();
        MoreFutures.mirror((ListenableFuture)fromFuture, (SettableFuture)toFuture, (boolean)true);
        fromFuture.set((Object)"abc");
        Assertions.assertThat((String)((String)toFuture.get())).isEqualTo("abc");
        fromFuture = ExtendedSettableFuture.create();
        toFuture = SettableFuture.create();
        MoreFutures.mirror((ListenableFuture)fromFuture, (SettableFuture)toFuture, (boolean)true);
        fromFuture.setException((Throwable)new RuntimeException());
        Assertions.assertThatThrownBy(() -> {
            String cfr_ignored_0 = (String)toFuture.get();
        }).isInstanceOf(ExecutionException.class);
        fromFuture = ExtendedSettableFuture.create();
        toFuture = SettableFuture.create();
        MoreFutures.mirror((ListenableFuture)fromFuture, (SettableFuture)toFuture, (boolean)false);
        toFuture.cancel(true);
        Assertions.assertThat((Future)fromFuture).isCancelled();
        Assertions.assertThat((boolean)fromFuture.checkWasInterrupted()).isFalse();
        fromFuture = ExtendedSettableFuture.create();
        toFuture = SettableFuture.create();
        MoreFutures.mirror((ListenableFuture)fromFuture, (SettableFuture)toFuture, (boolean)true);
        toFuture.cancel(false);
        Assertions.assertThat((Future)fromFuture).isCancelled();
        Assertions.assertThat((boolean)fromFuture.checkWasInterrupted()).isTrue();
    }

    @Test
    public void testUnwrapCompletionException() {
        RuntimeException original = new RuntimeException();
        Assertions.assertThat((Throwable)MoreFutures.unwrapCompletionException((Throwable)original)).isSameAs((Object)original);
        Assertions.assertThat((Throwable)MoreFutures.unwrapCompletionException((Throwable)new CompletionException(original))).isSameAs((Object)original);
        CompletionException completion = new CompletionException(null);
        Assertions.assertThat((Throwable)MoreFutures.unwrapCompletionException((Throwable)completion)).isSameAs((Object)completion);
    }

    @Test
    public void testModifyUnmodifiableFuture() {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture unmodifiableFuture = MoreFutures.unmodifiableFuture(future);
        TestMoreFutures.assertFailure(() -> unmodifiableFuture.complete("fail"), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, UnsupportedOperationException.class));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)unmodifiableFuture.isDone()).isFalse();
        TestMoreFutures.assertFailure(() -> unmodifiableFuture.completeExceptionally(new IOException()), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, UnsupportedOperationException.class));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)unmodifiableFuture.isDone()).isFalse();
        TestMoreFutures.assertFailure(() -> unmodifiableFuture.obtrudeValue("fail"), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, UnsupportedOperationException.class));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)unmodifiableFuture.isDone()).isFalse();
        TestMoreFutures.assertFailure(() -> unmodifiableFuture.obtrudeException(new IOException()), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, UnsupportedOperationException.class));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)unmodifiableFuture.isDone()).isFalse();
        Assertions.assertThat((boolean)unmodifiableFuture.cancel(false)).isFalse();
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)unmodifiableFuture.isDone()).isFalse();
        Assertions.assertThat((boolean)unmodifiableFuture.cancel(true)).isFalse();
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)unmodifiableFuture.isDone()).isFalse();
        Assertions.assertThat((boolean)unmodifiableFuture.completeExceptionally(new CancellationException())).isFalse();
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)unmodifiableFuture.isDone()).isFalse();
    }

    @Test
    public void testModifyCancelableUnmodifiableFuture() {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture unmodifiableFuture = MoreFutures.unmodifiableFuture(future, (boolean)true);
        TestMoreFutures.assertFailure(() -> unmodifiableFuture.complete("fail"), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, UnsupportedOperationException.class));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)unmodifiableFuture.isDone()).isFalse();
        TestMoreFutures.assertFailure(() -> unmodifiableFuture.completeExceptionally(new IOException()), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, UnsupportedOperationException.class));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)unmodifiableFuture.isDone()).isFalse();
        TestMoreFutures.assertFailure(() -> unmodifiableFuture.obtrudeValue("fail"), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, UnsupportedOperationException.class));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)unmodifiableFuture.isDone()).isFalse();
        TestMoreFutures.assertFailure(() -> unmodifiableFuture.obtrudeException(new IOException()), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, UnsupportedOperationException.class));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)unmodifiableFuture.isDone()).isFalse();
    }

    @Test
    public void testUnmodifiableFutureCancelPropagation() {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture unmodifiableFuture = MoreFutures.unmodifiableFuture(future, (boolean)true);
        Assertions.assertThat((boolean)unmodifiableFuture.cancel(false)).isTrue();
        Assertions.assertThat(future).isDone();
        Assertions.assertThat(future).isCancelled();
        Assertions.assertThat((CompletableFuture)unmodifiableFuture).isDone();
        Assertions.assertThat((CompletableFuture)unmodifiableFuture).isCancelled();
        future = new CompletableFuture();
        unmodifiableFuture = MoreFutures.unmodifiableFuture(future, (boolean)true);
        Assertions.assertThat((boolean)unmodifiableFuture.cancel(true)).isTrue();
        Assertions.assertThat(future).isDone();
        Assertions.assertThat(future).isCancelled();
        Assertions.assertThat((CompletableFuture)unmodifiableFuture).isDone();
        Assertions.assertThat((CompletableFuture)unmodifiableFuture).isCancelled();
        future = new CompletableFuture();
        unmodifiableFuture = MoreFutures.unmodifiableFuture(future, (boolean)true);
        Assertions.assertThat((boolean)unmodifiableFuture.completeExceptionally(new CancellationException())).isTrue();
        Assertions.assertThat(future).isDone();
        Assertions.assertThat(future).isCancelled();
        Assertions.assertThat((CompletableFuture)unmodifiableFuture).isDone();
        Assertions.assertThat((CompletableFuture)unmodifiableFuture).isCancelled();
    }

    @Test
    public void testCompleteUnmodifiableFuture() {
        CompletableFuture<String> future = new CompletableFuture<String>();
        CompletableFuture unmodifiableFuture = MoreFutures.unmodifiableFuture(future);
        Assertions.assertThat((boolean)future.complete("done")).isTrue();
        Assertions.assertThat((String)future.getNow(null)).isEqualTo("done");
        Assertions.assertThat((CompletableFuture)unmodifiableFuture).isDone();
        Assertions.assertThat((String)unmodifiableFuture.getNow(null)).isEqualTo("done");
    }

    @Test
    public void testCompleteExceptionallyUnmodifiableFuture() {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture unmodifiableFuture = MoreFutures.unmodifiableFuture(future);
        Assertions.assertThat((boolean)future.completeExceptionally(new SQLException("foo"))).isTrue();
        TestMoreFutures.assertFailure(() -> MoreFutures.getFutureValue((Future)future, SQLException.class), e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(SQLException.class)).hasMessage("foo"));
        Assertions.assertThat((CompletableFuture)unmodifiableFuture).isDone();
        TestMoreFutures.assertFailure(() -> MoreFutures.getFutureValue((Future)unmodifiableFuture, SQLException.class), e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(SQLException.class)).hasMessage("foo"));
    }

    @Test
    public void testAlreadyCompleteUnmodifiableFuture() {
        CompletableFuture<String> future = CompletableFuture.completedFuture("done");
        CompletableFuture unmodifiableFuture = MoreFutures.unmodifiableFuture(future);
        Assertions.assertThat((String)future.getNow(null)).isEqualTo("done");
        Assertions.assertThat((CompletableFuture)unmodifiableFuture).isDone();
        Assertions.assertThat((String)unmodifiableFuture.getNow(null)).isEqualTo("done");
    }

    @Test
    public void testAlreadyCompleteExceptionallyUnmodifiableFuture() {
        CompletableFuture future = MoreFutures.failedFuture((Throwable)new SQLException("foo"));
        CompletableFuture unmodifiableFuture = MoreFutures.unmodifiableFuture((CompletableFuture)future);
        TestMoreFutures.assertFailure(() -> MoreFutures.getFutureValue((Future)future, SQLException.class), e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(SQLException.class)).hasMessage("foo"));
        Assertions.assertThat((CompletableFuture)unmodifiableFuture).isDone();
        TestMoreFutures.assertFailure(() -> MoreFutures.getFutureValue((Future)unmodifiableFuture, SQLException.class), e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(SQLException.class)).hasMessage("foo"));
    }

    @Test
    public void testFailedFuture() {
        CompletableFuture future = MoreFutures.failedFuture((Throwable)new SQLException("foo"));
        Assertions.assertThat((CompletableFuture)future).isCompletedExceptionally();
        TestMoreFutures.assertFailure(future::get, e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(SQLException.class).hasRootCauseMessage("foo"));
    }

    @Test
    public void testGetFutureValue() throws Exception {
        this.assertGetUnchecked(MoreFutures::getFutureValue);
    }

    @Test
    public void testGetFutureValueWithExceptionType() throws Exception {
        this.assertGetUnchecked(future -> MoreFutures.getFutureValue((Future)future, IOException.class));
        TestMoreFutures.assertFailure(() -> MoreFutures.getFutureValue((Future)MoreFutures.failedFuture((Throwable)new SQLException("foo")), SQLException.class), e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(SQLException.class)).hasMessage("foo"));
    }

    @Test
    public void testTryGetFutureValue() throws Exception {
        this.assertGetUnchecked(future -> {
            Optional optional = MoreFutures.tryGetFutureValue((Future)future);
            if (optional.isPresent()) {
                return optional.get();
            }
            Assertions.assertThat((Object)MoreFutures.getFutureValue((Future)future)).isNull();
            return null;
        });
        Assertions.assertThat((Optional)MoreFutures.tryGetFutureValue(new CompletableFuture())).isEqualTo(Optional.empty());
    }

    @Test
    public void testTryGetFutureValueWithWait() throws Exception {
        this.assertGetUnchecked(future -> {
            Optional optional = MoreFutures.tryGetFutureValue((Future)future, (int)100, (TimeUnit)TimeUnit.MILLISECONDS);
            if (optional.isPresent()) {
                return optional.get();
            }
            Assertions.assertThat((Object)MoreFutures.getFutureValue((Future)future)).isNull();
            return null;
        });
        Assertions.assertThat((Optional)MoreFutures.tryGetFutureValue(new CompletableFuture(), (int)10, (TimeUnit)TimeUnit.MILLISECONDS)).isEqualTo(Optional.empty());
    }

    @Test
    public void testTryGetFutureValueWithExceptionType() throws Exception {
        this.assertGetUnchecked(future -> {
            Optional optional = MoreFutures.tryGetFutureValue((Future)future, (int)100, (TimeUnit)TimeUnit.MILLISECONDS, IOException.class);
            if (optional.isPresent()) {
                return optional.get();
            }
            Assertions.assertThat((Object)MoreFutures.getFutureValue((Future)future, IOException.class)).isNull();
            return null;
        });
        Assertions.assertThat((Optional)MoreFutures.tryGetFutureValue(new CompletableFuture(), (int)10, (TimeUnit)TimeUnit.MILLISECONDS)).isEqualTo(Optional.empty());
        TestMoreFutures.assertFailure(() -> MoreFutures.tryGetFutureValue((Future)MoreFutures.failedFuture((Throwable)new SQLException("foo")), (int)10, (TimeUnit)TimeUnit.MILLISECONDS, SQLException.class), e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(SQLException.class)).hasMessage("foo"));
    }

    @Test
    public void testWhenAnyComplete() throws Exception {
        TestMoreFutures.assertGetUncheckedListenable(future -> MoreFutures.getFutureValue((Future)MoreFutures.whenAnyComplete((Iterable)ImmutableList.of((Object)SettableFuture.create(), (Object)future, (Object)SettableFuture.create()))));
        TestMoreFutures.assertFailure(() -> MoreFutures.whenAnyComplete(null), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, NullPointerException.class));
        TestMoreFutures.assertFailure(() -> MoreFutures.whenAnyComplete((Iterable)ImmutableList.of()), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, IllegalArgumentException.class));
        Assertions.assertThat((Optional)MoreFutures.tryGetFutureValue((Future)MoreFutures.whenAnyComplete((Iterable)ImmutableList.of((Object)SettableFuture.create(), (Object)SettableFuture.create())), (int)10, (TimeUnit)TimeUnit.MILLISECONDS)).isEqualTo(Optional.empty());
    }

    @Test
    public void testWhenAnyCompleteCancelOthers() throws Exception {
        TestMoreFutures.assertGetUncheckedListenable(future -> {
            SettableFuture future1 = SettableFuture.create();
            SettableFuture future3 = SettableFuture.create();
            Object result = MoreFutures.getFutureValue((Future)MoreFutures.whenAnyCompleteCancelOthers((Iterable)ImmutableList.of((Object)future1, (Object)future, (Object)future3)));
            Assertions.assertThat((Future)future1).isCancelled();
            Assertions.assertThat((Future)future3).isCancelled();
            return result;
        });
        TestMoreFutures.assertFailure(() -> MoreFutures.whenAnyComplete(null), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, NullPointerException.class));
        TestMoreFutures.assertFailure(() -> MoreFutures.whenAnyComplete((Iterable)ImmutableList.of()), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, IllegalArgumentException.class));
        Assertions.assertThat((Optional)MoreFutures.tryGetFutureValue((Future)MoreFutures.whenAnyComplete((Iterable)ImmutableList.of((Object)SettableFuture.create(), (Object)SettableFuture.create())), (int)10, (TimeUnit)TimeUnit.MILLISECONDS)).isEqualTo(Optional.empty());
    }

    @Test
    public void testAnyOf() throws Exception {
        this.assertGetUnchecked(future -> MoreFutures.getFutureValue((Future)MoreFutures.firstCompletedFuture((Iterable)ImmutableList.of(new CompletableFuture(), (Object)future, new CompletableFuture()))));
        TestMoreFutures.assertFailure(() -> MoreFutures.firstCompletedFuture(null), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, NullPointerException.class));
        TestMoreFutures.assertFailure(() -> MoreFutures.firstCompletedFuture((Iterable)ImmutableList.of()), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, IllegalArgumentException.class));
        Assertions.assertThat((Optional)MoreFutures.tryGetFutureValue((Future)MoreFutures.firstCompletedFuture((Iterable)ImmutableList.of(new CompletableFuture(), new CompletableFuture())), (int)10, (TimeUnit)TimeUnit.MILLISECONDS)).isEqualTo(Optional.empty());
    }

    @Test
    public void testToFromListenableFuture() throws Exception {
        this.assertGetUnchecked(future -> MoreFutures.getFutureValue((Future)MoreFutures.toCompletableFuture((ListenableFuture)MoreFutures.toListenableFuture((CompletableFuture)future))));
        SettableFuture settableFuture = SettableFuture.create();
        MoreFutures.toCompletableFuture((ListenableFuture)settableFuture).cancel(true);
        Assertions.assertThat((Future)settableFuture).isCancelled();
        CompletableFuture completableFuture = new CompletableFuture();
        MoreFutures.toListenableFuture(completableFuture).cancel(true);
        Assertions.assertThat(completableFuture).isCancelled();
        Assertions.assertThat((Optional)MoreFutures.tryGetFutureValue((Future)MoreFutures.toCompletableFuture((ListenableFuture)SettableFuture.create()), (int)10, (TimeUnit)TimeUnit.MILLISECONDS)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)MoreFutures.tryGetFutureValue((Future)MoreFutures.toListenableFuture(new CompletableFuture()), (int)10, (TimeUnit)TimeUnit.MILLISECONDS)).isEqualTo(Optional.empty());
    }

    @Test
    public void testEmptyAllAsList() {
        CompletableFuture future = MoreFutures.allAsList((List)ImmutableList.of());
        Assertions.assertThat((CompletableFuture)future).isDone();
        Assertions.assertThat((CompletableFuture)future).isNotCompletedExceptionally();
        Assertions.assertThat((CompletableFuture)future).isNotCancelled();
        Assertions.assertThat((List)((List)future.join())).isEqualTo((Object)ImmutableList.of());
    }

    @Test
    public void testSingleElementAllAsList() {
        CompletableFuture<String> element1 = new CompletableFuture<String>();
        CompletableFuture future = MoreFutures.allAsList((List)ImmutableList.of(element1));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)future.isCancelled()).isFalse();
        element1.complete("a");
        Assertions.assertThat((CompletableFuture)future).isDone();
        Assertions.assertThat((CompletableFuture)future).isNotCompletedExceptionally();
        Assertions.assertThat((CompletableFuture)future).isNotCancelled();
        Assertions.assertThat((List)((List)future.join())).isEqualTo((Object)ImmutableList.of((Object)"a"));
    }

    @Test
    public void testExceptionalSingleElementAllAsList() {
        CompletableFuture element1 = new CompletableFuture();
        CompletableFuture future = MoreFutures.allAsList((List)ImmutableList.of(element1));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)future.isCancelled()).isFalse();
        element1.completeExceptionally(new RuntimeException());
        Assertions.assertThat((CompletableFuture)future).isDone();
        Assertions.assertThat((CompletableFuture)future).isCompletedExceptionally();
        Assertions.assertThat((CompletableFuture)future).isNotCancelled();
    }

    @Test
    public void testMultipleElementAllAsList() {
        CompletableFuture<String> element1 = new CompletableFuture<String>();
        CompletableFuture<String> element2 = new CompletableFuture<String>();
        CompletableFuture future = MoreFutures.allAsList((List)ImmutableList.of(element1, element2));
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)future.isCancelled()).isFalse();
        element1.complete("a");
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        Assertions.assertThat((boolean)future.isCompletedExceptionally()).isFalse();
        Assertions.assertThat((boolean)future.isCancelled()).isFalse();
        element2.complete("b");
        Assertions.assertThat((CompletableFuture)future).isDone();
        Assertions.assertThat((CompletableFuture)future).isNotCompletedExceptionally();
        Assertions.assertThat((CompletableFuture)future).isNotCancelled();
        Assertions.assertThat((List)((List)future.join())).isEqualTo((Object)ImmutableList.of((Object)"a", (Object)"b"));
    }

    @Test
    public void testExceptionalMultipleElementAllAsList() {
        CompletableFuture element1 = new CompletableFuture();
        CompletableFuture element2 = new CompletableFuture();
        CompletableFuture future = MoreFutures.allAsList((List)ImmutableList.of(element1, element2));
        Assertions.assertThat((CompletableFuture)future).isNotDone();
        Assertions.assertThat((CompletableFuture)future).isNotCompletedExceptionally();
        Assertions.assertThat((CompletableFuture)future).isNotCancelled();
        element1.completeExceptionally(new RuntimeException());
        Assertions.assertThat((CompletableFuture)future).isDone();
        Assertions.assertThat((CompletableFuture)future).isCompletedExceptionally();
        Assertions.assertThat((CompletableFuture)future).isNotCancelled();
    }

    @Test
    public void testUnmodifiableAllAsList() {
        CompletableFuture future = MoreFutures.allAsList((List)ImmutableList.of(new CompletableFuture()));
        Assertions.assertThatThrownBy(() -> future.complete(null)).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testListenableTimeout() {
        SettableFuture rootFuture = SettableFuture.create();
        ListenableFuture timeoutFuture = MoreFutures.addTimeout((ListenableFuture)rootFuture, () -> "timeout", (Duration)new Duration(0.0, TimeUnit.MILLISECONDS), (ScheduledExecutorService)this.executorService);
        Assertions.assertThat((String)MoreFutures.tryGetFutureValue((Future)timeoutFuture, (int)10, (TimeUnit)TimeUnit.SECONDS).orElse("failed")).isEqualTo("timeout");
        Assertions.assertThat((Future)timeoutFuture).isDone();
        Assertions.assertThat((Future)timeoutFuture).isNotCancelled();
        TestMoreFutures.assertFailure(() -> rootFuture.get(10L, TimeUnit.SECONDS), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, CancellationException.class));
        Assertions.assertThat((Future)rootFuture).isDone();
        Assertions.assertThat((Future)rootFuture).isCancelled();
    }

    @Test
    public void testListenableTimeoutExceptionValue() {
        SettableFuture rootFuture = SettableFuture.create();
        ListenableFuture timeoutFuture = MoreFutures.addTimeout((ListenableFuture)rootFuture, () -> {
            throw new SQLException("timeout");
        }, (Duration)new Duration(0.0, TimeUnit.MILLISECONDS), (ScheduledExecutorService)this.executorService);
        TestMoreFutures.assertFailure(() -> MoreFutures.tryGetFutureValue((Future)timeoutFuture, (int)10, (TimeUnit)TimeUnit.SECONDS, SQLException.class), e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(SQLException.class)).hasMessage("timeout"));
        Assertions.assertThat((Future)timeoutFuture).isDone();
        Assertions.assertThat((Future)timeoutFuture).isNotCancelled();
        TestMoreFutures.assertFailure(() -> rootFuture.get(10L, TimeUnit.SECONDS), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, CancellationException.class));
        Assertions.assertThat((Future)rootFuture).isDone();
        Assertions.assertThat((Future)rootFuture).isCancelled();
    }

    @Test
    public void testListenableTimeoutCancel() {
        SettableFuture rootFuture = SettableFuture.create();
        ListenableFuture timeoutFuture = MoreFutures.addTimeout((ListenableFuture)rootFuture, () -> "timeout", (Duration)new Duration(10.0, TimeUnit.SECONDS), (ScheduledExecutorService)this.executorService);
        Assertions.assertThat((Optional)MoreFutures.tryGetFutureValue((Future)timeoutFuture, (int)10, (TimeUnit)TimeUnit.MILLISECONDS)).isEqualTo(Optional.empty());
        Assertions.assertThat((boolean)timeoutFuture.cancel(true)).isTrue();
        Assertions.assertThat((Future)timeoutFuture).isDone();
        Assertions.assertThat((Future)timeoutFuture).isCancelled();
        TestMoreFutures.assertFailure(() -> rootFuture.get(10L, TimeUnit.SECONDS), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, CancellationException.class));
        Assertions.assertThat((Future)rootFuture).isDone();
        Assertions.assertThat((Future)rootFuture).isCancelled();
    }

    @Test
    public void testTimeout() {
        CompletableFuture rootFuture = new CompletableFuture();
        CompletableFuture timeoutFuture = MoreFutures.addTimeout(rootFuture, () -> "timeout", (Duration)new Duration(0.0, TimeUnit.MILLISECONDS), (ScheduledExecutorService)this.executorService);
        Assertions.assertThat((String)MoreFutures.tryGetFutureValue((Future)timeoutFuture, (int)10, (TimeUnit)TimeUnit.SECONDS).orElse("failed")).isEqualTo("timeout");
        Assertions.assertThat((CompletableFuture)timeoutFuture).isDone();
        Assertions.assertThat((CompletableFuture)timeoutFuture).isNotCancelled();
        TestMoreFutures.assertFailure(() -> rootFuture.get(10L, TimeUnit.SECONDS), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, CancellationException.class));
        Assertions.assertThat(rootFuture).isDone();
        Assertions.assertThat(rootFuture).isCancelled();
    }

    @Test
    public void testTimeoutExceptionValue() {
        CompletableFuture rootFuture = new CompletableFuture();
        CompletableFuture timeoutFuture = MoreFutures.addTimeout(rootFuture, () -> {
            throw new SQLException("timeout");
        }, (Duration)new Duration(0.0, TimeUnit.MILLISECONDS), (ScheduledExecutorService)this.executorService);
        TestMoreFutures.assertFailure(() -> MoreFutures.tryGetFutureValue((Future)timeoutFuture, (int)10, (TimeUnit)TimeUnit.SECONDS, SQLException.class), e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(SQLException.class)).hasMessage("timeout"));
        Assertions.assertThat((CompletableFuture)timeoutFuture).isDone();
        Assertions.assertThat((CompletableFuture)timeoutFuture).isNotCancelled();
        TestMoreFutures.assertFailure(() -> rootFuture.get(10L, TimeUnit.SECONDS), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, CancellationException.class));
        Assertions.assertThat(rootFuture).isDone();
        Assertions.assertThat(rootFuture).isCancelled();
    }

    @Test
    public void testTimeoutCancel() {
        CompletableFuture rootFuture = new CompletableFuture();
        CompletableFuture timeoutFuture = MoreFutures.addTimeout(rootFuture, () -> "timeout", (Duration)new Duration(10.0, TimeUnit.SECONDS), (ScheduledExecutorService)this.executorService);
        Assertions.assertThat((Optional)MoreFutures.tryGetFutureValue((Future)timeoutFuture, (int)10, (TimeUnit)TimeUnit.MILLISECONDS)).isEqualTo(Optional.empty());
        Assertions.assertThat((boolean)timeoutFuture.cancel(true)).isTrue();
        Assertions.assertThat((CompletableFuture)timeoutFuture).isDone();
        Assertions.assertThat((CompletableFuture)timeoutFuture).isCancelled();
        TestMoreFutures.assertFailure(() -> rootFuture.get(10L, TimeUnit.SECONDS), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, CancellationException.class));
        Assertions.assertThat(rootFuture).isDone();
        Assertions.assertThat(rootFuture).isCancelled();
    }

    @Test
    public void testGetDone() {
        Assertions.assertThat((String)((String)MoreFutures.getDone((Future)Futures.immediateFuture((Object)"Alice")))).isEqualTo("Alice");
        TestMoreFutures.assertFailure(() -> MoreFutures.getDone((Future)Futures.immediateFailedFuture((Throwable)new IllegalStateException("some failure"))), TestMoreFutures.expect(IllegalStateException.class, "some failure"));
        TestMoreFutures.assertFailure(() -> MoreFutures.getDone((Future)Futures.immediateFailedFuture((Throwable)new IOException("some failure"))), TestMoreFutures.expect(RuntimeException.class, "java.io.IOException: some failure", TestMoreFutures.expect(IOException.class, "some failure")));
        TestMoreFutures.assertFailure(() -> MoreFutures.getDone((Future)SettableFuture.create()), TestMoreFutures.expect(IllegalArgumentException.class, "future not done yet"));
        TestMoreFutures.assertFailure(() -> MoreFutures.getDone(null), TestMoreFutures.expect(NullPointerException.class, "future is null"));
    }

    @Test
    public void testCheckSuccess() {
        MoreFutures.checkSuccess((Future)Futures.immediateFuture((Object)"Alice"), (String)"this should not fail");
        TestMoreFutures.assertFailure(() -> MoreFutures.checkSuccess((Future)Futures.immediateFailedFuture((Throwable)new IllegalStateException("some failure")), (String)"msg"), TestMoreFutures.expect(IllegalArgumentException.class, "msg", TestMoreFutures.expect(IllegalStateException.class, "some failure")));
        TestMoreFutures.assertFailure(() -> MoreFutures.checkSuccess((Future)Futures.immediateFailedFuture((Throwable)new IOException("some failure")), (String)"msg"), TestMoreFutures.expect(IllegalArgumentException.class, "msg", TestMoreFutures.expect(RuntimeException.class, "java.io.IOException: some failure", TestMoreFutures.expect(IOException.class, "some failure"))));
        TestMoreFutures.assertFailure(() -> MoreFutures.checkSuccess((Future)SettableFuture.create(), (String)"msg"), TestMoreFutures.expect(IllegalArgumentException.class, "future not done yet"));
        TestMoreFutures.assertFailure(() -> MoreFutures.checkSuccess(null, (String)"msg"), TestMoreFutures.expect(NullPointerException.class, "future is null"));
    }

    @Test
    public void testAllAsListWithCancellationOnFailure() {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture listFuture = MoreFutures.allAsListWithCancellationOnFailure((Iterable)ImmutableList.of((Object)future1, (Object)future2));
        Assertions.assertThat((Future)listFuture).isNotDone();
        future1.setException((Throwable)new RuntimeException("future failure"));
        Assertions.assertThat((Future)listFuture).failsWithin(0L, TimeUnit.SECONDS).withThrowableOfType(ExecutionException.class).withMessageContaining("future failure");
        Assertions.assertThat((Future)future2).isCancelled();
    }

    private static void assertGetUncheckedListenable(Function<ListenableFuture<Object>, Object> getter) {
        Assertions.assertThat((Object)getter.apply((ListenableFuture<Object>)Futures.immediateFuture((Object)"foo"))).isEqualTo((Object)"foo");
        TestMoreFutures.assertFailure(() -> getter.apply(Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("foo"))), e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class)).hasMessage("foo"));
        TestMoreFutures.assertFailure(() -> getter.apply(Futures.immediateFailedFuture((Throwable)new SQLException("foo"))), e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(RuntimeException.class)).hasCauseInstanceOf(SQLException.class).hasRootCauseMessage("foo"));
        Thread.currentThread().interrupt();
        TestMoreFutures.assertFailure(() -> getter.apply((ListenableFuture<Object>)SettableFuture.create()), e -> {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(RuntimeException.class)).hasCauseInstanceOf(InterruptedException.class);
            Assertions.assertThat((boolean)Thread.interrupted()).isTrue();
        });
        Assertions.assertThat((boolean)Thread.currentThread().isInterrupted()).isFalse();
        SettableFuture canceledFuture = SettableFuture.create();
        canceledFuture.cancel(true);
        TestMoreFutures.assertFailure(() -> getter.apply((ListenableFuture<Object>)canceledFuture), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, CancellationException.class));
        Assertions.assertThat((Object)getter.apply((ListenableFuture<Object>)Futures.immediateFuture(null))).isEqualTo(null);
    }

    private void assertGetUnchecked(UncheckedGetter getter) throws Exception {
        TestMoreFutures.assertGetUncheckedInternal(getter);
        TestMoreFutures.assertGetUncheckedInternal(future -> getter.get(MoreFutures.addTimeout((CompletableFuture)future, () -> {
            throw new RuntimeException("timeout");
        }, (Duration)new Duration(10.0, TimeUnit.SECONDS), (ScheduledExecutorService)this.executorService)));
    }

    private static void assertGetUncheckedInternal(UncheckedGetter getter) throws Exception {
        Assertions.assertThat((Object)getter.get(CompletableFuture.completedFuture("foo"))).isEqualTo((Object)"foo");
        TestMoreFutures.assertFailure(() -> getter.get(MoreFutures.failedFuture((Throwable)new IllegalArgumentException("foo"))), e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class)).hasMessage("foo"));
        TestMoreFutures.assertFailure(() -> getter.get(MoreFutures.failedFuture((Throwable)new SQLException("foo"))), e -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(RuntimeException.class)).hasCauseInstanceOf(SQLException.class).hasRootCauseMessage("foo"));
        Thread.currentThread().interrupt();
        TestMoreFutures.assertFailure(() -> getter.get(new CompletableFuture<Object>()), e -> {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(RuntimeException.class)).hasCauseInstanceOf(InterruptedException.class);
            Assertions.assertThat((boolean)Thread.interrupted()).isTrue();
        });
        Assertions.assertThat((boolean)Thread.currentThread().isInterrupted()).isFalse();
        CompletableFuture canceledFuture = new CompletableFuture();
        canceledFuture.cancel(true);
        TestMoreFutures.assertFailure(() -> getter.get(canceledFuture), e -> io.airlift.testing.Assertions.assertInstanceOf((Object)e, CancellationException.class));
        Assertions.assertThat((Object)getter.get(CompletableFuture.completedFuture(null))).isEqualTo(null);
    }

    private static void assertFailure(Thrower thrower, Consumer<Throwable> verifier) {
        try {
            thrower.execute();
        }
        catch (Throwable throwable) {
            verifier.accept(throwable);
            return;
        }
        Assertions.fail((String)"expected exception to be thrown");
    }

    private static Consumer<Throwable> expect(Class<? extends Throwable> expectedClass, String expectedMessagePattern) {
        return TestMoreFutures.expect(expectedClass, expectedMessagePattern, cause -> {});
    }

    private static Consumer<Throwable> expect(Class<? extends Throwable> expectedClass, String expectedMessagePattern, Consumer<? super Throwable> causeVerifier) {
        return e -> {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).as("exception is null", new Object[0])).isNotNull();
            if (!expectedClass.isInstance(e) || !Strings.nullToEmpty((String)e.getMessage()).matches(expectedMessagePattern)) {
                Assertions.fail((String)String.format("Expected %s with message '%s', got: %s", expectedClass, expectedMessagePattern, e));
            }
            causeVerifier.accept(e.getCause());
        };
    }

    private static interface Thrower {
        public void execute() throws Throwable;
    }

    private static interface UncheckedGetter {
        public Object get(CompletableFuture<Object> var1) throws Exception;
    }
}

