/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.dbpool;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.dbpool.H2EmbeddedDataSource;
import io.airlift.dbpool.H2EmbeddedDataSourceModule;
import io.airlift.testing.Assertions;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.sql.DataSource;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestH2EmbeddedDataSourceModule {
    private File temporaryFile;

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullPrefixInConstructionThrows() {
        H2EmbeddedDataSourceModule notActuallyConstructed = new H2EmbeddedDataSourceModule(null, MainBinding.class, new Class[0]);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullAnnotationInConstructionThrows() {
        H2EmbeddedDataSourceModule notActuallyConstructed = new H2EmbeddedDataSourceModule("test", null, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testEmptyPrefixStringInConstructionThrows() {
        H2EmbeddedDataSourceModule notActuallyConstructed = new H2EmbeddedDataSourceModule("", MainBinding.class, new Class[0]);
    }

    @Test(groups={"requiresTempFile"})
    public void testObjectBindingFromInjector() {
        String prefix = "test";
        Map<String, String> properties = TestH2EmbeddedDataSourceModule.createDefaultConfigurationProperties("test", this.temporaryFile.getAbsolutePath());
        Injector injector = TestH2EmbeddedDataSourceModule.createInjector(properties, new Module[]{new H2EmbeddedDataSourceModule("test", MainBinding.class, new Class[0])});
        ObjectHolder objectHolder = (ObjectHolder)injector.getInstance(ObjectHolder.class);
        Assertions.assertInstanceOf((Object)objectHolder.dataSource, H2EmbeddedDataSource.class);
    }

    @Test(groups={"requiresTempFile"})
    public void testBoundObjectIsASingleton() {
        String prefix = "test";
        Map<String, String> properties = TestH2EmbeddedDataSourceModule.createDefaultConfigurationProperties("test", this.temporaryFile.getAbsolutePath());
        Injector injector = TestH2EmbeddedDataSourceModule.createInjector(properties, new Module[]{new H2EmbeddedDataSourceModule("test", MainBinding.class, new Class[0])});
        ObjectHolder objectHolder1 = (ObjectHolder)injector.getInstance(ObjectHolder.class);
        ObjectHolder objectHolder2 = (ObjectHolder)injector.getInstance(ObjectHolder.class);
        Assert.assertNotSame((Object)objectHolder1, (Object)objectHolder2, (String)"Expected holding objects to be different");
        Assert.assertSame((Object)objectHolder1.dataSource, (Object)objectHolder2.dataSource);
    }

    @Test(groups={"requiresTempFile"})
    public void testAliasedBindingBindsCorrectly() {
        String prefix = "test";
        Map<String, String> properties = TestH2EmbeddedDataSourceModule.createDefaultConfigurationProperties("test", this.temporaryFile.getAbsolutePath());
        Injector injector = TestH2EmbeddedDataSourceModule.createInjector(properties, new Module[]{new H2EmbeddedDataSourceModule("test", MainBinding.class, new Class[]{AliasBinding.class}), new Module(){

            public void configure(Binder binder) {
                binder.bind(TwoObjectsHolder.class);
            }
        }});
        ObjectHolder objectHolder = (ObjectHolder)injector.getInstance(ObjectHolder.class);
        TwoObjectsHolder twoObjectsHolder = (TwoObjectsHolder)injector.getInstance(TwoObjectsHolder.class);
        Assertions.assertInstanceOf((Object)twoObjectsHolder.mainDataSource, H2EmbeddedDataSource.class);
        Assertions.assertInstanceOf((Object)twoObjectsHolder.aliasedDataSource, H2EmbeddedDataSource.class);
        Assert.assertSame((Object)objectHolder.dataSource, (Object)twoObjectsHolder.mainDataSource);
        Assert.assertSame((Object)objectHolder.dataSource, (Object)twoObjectsHolder.aliasedDataSource);
    }

    @Test(groups={"requiresTempFile"})
    public void testCorrectConfigurationPrefix() {
        String expectedPrefix = "expected";
        String otherPrefix = "additional";
        String propertySuffixToTest = ".db.connections.max";
        int expectedValue = 1234;
        Map<String, String> properties = TestH2EmbeddedDataSourceModule.createDefaultConfigurationProperties("expected", this.temporaryFile.getAbsolutePath());
        properties.put("additional.db.connections.max", Integer.toString(6912));
        properties.put("expected.db.connections.max", Integer.toString(1234));
        Injector injector = TestH2EmbeddedDataSourceModule.createInjector(properties, new Module[]{new H2EmbeddedDataSourceModule("expected", MainBinding.class, new Class[0])});
        ObjectHolder objectHolder = (ObjectHolder)injector.getInstance(ObjectHolder.class);
        Assertions.assertInstanceOf((Object)objectHolder.dataSource, H2EmbeddedDataSource.class);
        H2EmbeddedDataSource created = (H2EmbeddedDataSource)objectHolder.dataSource;
        Assert.assertEquals((int)created.getMaxConnections(), (int)1234, (String)"Property value not loaded from correct prefix");
    }

    @Test(groups={"requiresTempFile"}, expectedExceptions={CreationException.class})
    public void testIncorrectConfigurationPrefixThrows() {
        String configurationPrefix = "configuration";
        String constructionPrefix = "differentFromConfiguration";
        Map<String, String> properties = TestH2EmbeddedDataSourceModule.createDefaultConfigurationProperties("configuration", this.temporaryFile.getAbsolutePath());
        TestH2EmbeddedDataSourceModule.createInjector(properties, new Module[]{new H2EmbeddedDataSourceModule("differentFromConfiguration", MainBinding.class, new Class[0])});
    }

    private static Injector createInjector(Map<String, String> properties, Module ... modules) {
        ConfigurationFactory configurationFactory = new ConfigurationFactory(properties);
        ImmutableList moduleList = ImmutableList.builder().add((Object[])modules).add((Object)new ConfigurationModule(configurationFactory)).add((Object)new Module(){

            public void configure(Binder binder) {
                binder.bind(MBeanServer.class).toInstance(Mockito.mock(MBeanServer.class));
                binder.bind(ObjectHolder.class);
            }
        }).build();
        return Guice.createInjector((Iterable)moduleList);
    }

    @BeforeMethod(groups={"requiresTempFile"})
    private void createTempFile() throws IOException {
        this.temporaryFile = File.createTempFile("h2db-", ".db");
    }

    @AfterMethod(groups={"requiresTempFile"})
    private void deleteTempFile() {
        this.temporaryFile.delete();
    }

    private static Map<String, String> createDefaultConfigurationProperties(String prefix, String filename) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        properties.put(prefix + "db.filename", filename);
        properties.put(prefix + "db.init-script", "io/airlift/dbpool/h2.ddl");
        properties.put(prefix + "db.cipher", "AES");
        properties.put(prefix + "db.file-password", "filePassword");
        return properties;
    }

    public static class TwoObjectsHolder {
        public final DataSource mainDataSource;
        public final DataSource aliasedDataSource;

        @Inject
        public TwoObjectsHolder(@MainBinding DataSource mainDataSource, @AliasBinding DataSource aliasedDataSource) {
            this.mainDataSource = mainDataSource;
            this.aliasedDataSource = aliasedDataSource;
        }
    }

    public static class ObjectHolder {
        public final DataSource dataSource;

        @Inject
        public ObjectHolder(@MainBinding DataSource dataSource) {
            this.dataSource = dataSource;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    public static @interface AliasBinding {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @BindingAnnotation
    public static @interface MainBinding {
    }
}

