/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.dbpool;

import com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource;
import io.airlift.dbpool.ManagedDataSource;
import io.airlift.dbpool.MySqlDataSourceConfig;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceSelector;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.PooledConnection;

public class MySqlDataSource
extends ManagedDataSource {
    private final ServiceSelector serviceSelector;
    private final int defaultFetchSize;
    private UUID currentServer;
    private MysqlConnectionPoolDataSource dataSource;

    public MySqlDataSource(ServiceSelector serviceSelector, MySqlDataSourceConfig config) {
        super(config.getMaxConnections(), config.getMaxConnectionWait());
        this.serviceSelector = serviceSelector;
        this.defaultFetchSize = config.getDefaultFetchSize();
    }

    @Override
    protected PooledConnection createConnectionInternal() throws SQLException {
        SQLException lastException = null;
        if (this.dataSource != null) {
            try {
                return this.dataSource.getPooledConnection();
            }
            catch (SQLException e) {
                lastException = e;
            }
        }
        this.dataSource = null;
        for (ServiceDescriptor serviceDescriptor : this.serviceSelector.selectAllServices()) {
            String jdbcUrl;
            if (serviceDescriptor.getId().equals(this.currentServer) || (jdbcUrl = (String)serviceDescriptor.getProperties().get("jdbc")) == null) continue;
            try {
                MysqlConnectionPoolDataSource dataSource = new MysqlConnectionPoolDataSource();
                dataSource.setUrl(jdbcUrl);
                dataSource.setConnectTimeout(this.getMaxConnectionWaitMillis());
                dataSource.setInitialTimeout(this.getMaxConnectionWaitMillis());
                dataSource.setDefaultFetchSize(this.defaultFetchSize);
                PooledConnection connection = dataSource.getPooledConnection();
                this.dataSource = dataSource;
                this.currentServer = serviceDescriptor.getId();
                return connection;
            }
            catch (SQLException e) {
                lastException = e;
            }
        }
        this.currentServer = null;
        if (lastException != null) {
            throw lastException;
        }
        throw new SQLException(String.format("No mysql servers of type '%s' available in pool '%s'", this.serviceSelector.getType(), this.serviceSelector.getPool()));
    }
}

