/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.dbpool;

import io.airlift.dbpool.DatabaseIpAddressUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DatabaseIpAddressUtilTest {
    @Test
    public void test() throws Exception {
        this.verifyIpAddressConversion("0.0.0.0", 0, Integer.MIN_VALUE);
        this.verifyIpAddressConversion("255.255.255.255", -1, Integer.MAX_VALUE);
        this.verifyIpAddressConversion("128.0.0.0", Integer.MIN_VALUE, 0);
        this.verifyIpAddressConversion("127.255.255.255", Integer.MAX_VALUE, -1);
    }

    private void verifyIpAddressConversion(String ipString, int expectedJavaIpAddress, int expectedDatabaseIpAddress) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(ipString);
        int javaIpAddress = address.hashCode();
        Assert.assertEquals((int)javaIpAddress, (int)expectedJavaIpAddress);
        int databaseIpAddress = DatabaseIpAddressUtil.toDatabaseIpAddress((int)javaIpAddress);
        Assert.assertEquals((int)databaseIpAddress, (int)expectedDatabaseIpAddress);
        Assert.assertEquals((int)DatabaseIpAddressUtil.fromDatabaseIpAddress((int)databaseIpAddress), (int)javaIpAddress);
    }
}

