/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.dbpool;

import io.airlift.dbpool.ManagedSemaphore;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestManagedSemaphore {
    @Test
    public void testSinglePermit() throws InterruptedException {
        ManagedSemaphore semaphore = new ManagedSemaphore(1);
        this.assertPermits(semaphore, 1, 0);
        Assert.assertTrue((boolean)semaphore.tryAcquire());
        this.assertPermits(semaphore, 1, 1);
        Assert.assertFalse((boolean)semaphore.tryAcquire());
        this.assertPermits(semaphore, 1, 1);
        semaphore.release();
        this.assertPermits(semaphore, 1, 0);
        Assert.assertTrue((boolean)semaphore.tryAcquire());
        this.assertPermits(semaphore, 1, 1);
        Assert.assertFalse((boolean)semaphore.tryAcquire());
        this.assertPermits(semaphore, 1, 1);
        semaphore.release();
        this.assertPermits(semaphore, 1, 0);
        Assert.assertTrue((boolean)semaphore.tryAcquire(1L, TimeUnit.MILLISECONDS));
        this.assertPermits(semaphore, 1, 1);
        Assert.assertFalse((boolean)semaphore.tryAcquire(1L, TimeUnit.MILLISECONDS));
        this.assertPermits(semaphore, 1, 1);
        semaphore.release();
        this.assertPermits(semaphore, 1, 0);
        semaphore.acquire();
        this.assertPermits(semaphore, 1, 1);
        semaphore.release();
        this.assertPermits(semaphore, 1, 0);
        semaphore.acquireUninterruptibly();
        this.assertPermits(semaphore, 1, 1);
        semaphore.release();
        this.assertPermits(semaphore, 1, 0);
        Assert.assertEquals((int)semaphore.drainPermits(), (int)1);
        this.assertPermits(semaphore, 1, 1);
    }

    @Test
    public void testMultiplePermit() throws InterruptedException {
        ManagedSemaphore semaphore = new ManagedSemaphore(3);
        this.assertPermits(semaphore, 3, 0);
        Assert.assertTrue((boolean)semaphore.tryAcquire(2));
        this.assertPermits(semaphore, 3, 2);
        Assert.assertFalse((boolean)semaphore.tryAcquire(2));
        this.assertPermits(semaphore, 3, 2);
        semaphore.release(2);
        this.assertPermits(semaphore, 3, 0);
        Assert.assertTrue((boolean)semaphore.tryAcquire(2));
        this.assertPermits(semaphore, 3, 2);
        Assert.assertFalse((boolean)semaphore.tryAcquire(2));
        this.assertPermits(semaphore, 3, 2);
        semaphore.release(2);
        this.assertPermits(semaphore, 3, 0);
        Assert.assertTrue((boolean)semaphore.tryAcquire(2, 1L, TimeUnit.MILLISECONDS));
        this.assertPermits(semaphore, 3, 2);
        Assert.assertFalse((boolean)semaphore.tryAcquire(2, 1L, TimeUnit.MILLISECONDS));
        this.assertPermits(semaphore, 3, 2);
        semaphore.release(2);
        this.assertPermits(semaphore, 3, 0);
        semaphore.acquire(2);
        this.assertPermits(semaphore, 3, 2);
        semaphore.release(2);
        this.assertPermits(semaphore, 3, 0);
        semaphore.acquireUninterruptibly(2);
        this.assertPermits(semaphore, 3, 2);
        semaphore.release(2);
        this.assertPermits(semaphore, 3, 0);
        Assert.assertEquals((int)semaphore.drainPermits(), (int)3);
        this.assertPermits(semaphore, 3, 3);
    }

    @Test
    public void adjustPermits() {
        ManagedSemaphore semaphore = new ManagedSemaphore(1);
        this.assertPermits(semaphore, 1, 0);
        Assert.assertTrue((boolean)semaphore.tryAcquire());
        this.assertPermits(semaphore, 1, 1);
        Assert.assertFalse((boolean)semaphore.tryAcquire());
        this.assertPermits(semaphore, 1, 1);
        semaphore.setPermits(3);
        this.assertPermits(semaphore, 3, 1);
        Assert.assertTrue((boolean)semaphore.tryAcquire(2));
        this.assertPermits(semaphore, 3, 3);
        Assert.assertFalse((boolean)semaphore.tryAcquire());
        this.assertPermits(semaphore, 3, 3);
        semaphore.setPermits(2);
        this.assertPermits(semaphore, 2, 3);
        Assert.assertFalse((boolean)semaphore.tryAcquire());
        this.assertPermits(semaphore, 2, 3);
        semaphore.release();
        this.assertPermits(semaphore, 2, 2);
        Assert.assertFalse((boolean)semaphore.tryAcquire());
        this.assertPermits(semaphore, 2, 2);
        semaphore.release();
        this.assertPermits(semaphore, 2, 1);
        Assert.assertTrue((boolean)semaphore.tryAcquire());
        this.assertPermits(semaphore, 2, 2);
        semaphore.release(2);
        this.assertPermits(semaphore, 2, 0);
    }

    private void assertPermits(ManagedSemaphore semaphore, int totalPermits, int checkedOutPermits) {
        Assert.assertEquals((int)semaphore.getPermits(), (int)totalPermits);
        Assert.assertEquals((long)semaphore.getActivePermits(), (long)checkedOutPermits);
        Assert.assertEquals((int)semaphore.getAvailablePermits(), (int)(totalPermits - checkedOutPermits));
        Assert.assertEquals((int)semaphore.availablePermits(), (int)(totalPermits - checkedOutPermits));
    }
}

