/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.dbpool;

import io.airlift.stats.TimedStat;
import io.airlift.units.Duration;
import java.util.concurrent.atomic.AtomicLong;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public final class ManagedDataSourceStats {
    private final TimedStat checkout = new TimedStat();
    private final TimedStat create = new TimedStat();
    private final TimedStat held = new TimedStat();
    private final AtomicLong connectionErrorCount = new AtomicLong();
    private final AtomicLong creationErrorCount = new AtomicLong();

    @Managed
    @Nested
    public TimedStat getCheckout() {
        return this.checkout;
    }

    @Managed
    @Nested
    public TimedStat getCreate() {
        return this.create;
    }

    @Managed
    @Nested
    public TimedStat getHeld() {
        return this.held;
    }

    @Managed
    public long getConnectionErrorCount() {
        return this.connectionErrorCount.get();
    }

    @Managed
    public long getCreationErrorCount() {
        return this.creationErrorCount.get();
    }

    void connectionCheckedOut(Duration elapsedTime) {
        this.checkout.addValue(elapsedTime);
    }

    void connectionCreated(Duration elapsedTime) {
        this.create.addValue(elapsedTime);
    }

    void connectionReturned(Duration elapsedTime) {
        this.held.addValue(elapsedTime);
    }

    void creationErrorOccurred() {
        this.creationErrorCount.incrementAndGet();
    }

    void connectionErrorOccurred() {
        this.connectionErrorCount.incrementAndGet();
    }
}

