/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.dbpool;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import io.airlift.dbpool.H2EmbeddedDataSource;
import io.airlift.dbpool.H2EmbeddedDataSourceConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.h2.jdbc.JdbcSQLSyntaxErrorException;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class H2EmbeddedDataSourceTest {
    private File file;

    @BeforeMethod
    public void setup() throws IOException {
        this.file = File.createTempFile("h2db-", ".db");
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() {
        this.file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitFromResource() throws Exception {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            H2EmbeddedDataSourceConfig config = new H2EmbeddedDataSourceConfig().setFilename(this.file.getAbsolutePath()).setInitScript("io/airlift/dbpool/h2.ddl").setCipher(H2EmbeddedDataSourceConfig.Cipher.AES).setFilePassword("filePassword");
            H2EmbeddedDataSource dataSource = new H2EmbeddedDataSource(config);
            connection = dataSource.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select * from message");
        }
        catch (Throwable throwable) {
            H2EmbeddedDataSourceTest.closeQuietly(resultSet);
            H2EmbeddedDataSourceTest.closeQuietly(statement);
            H2EmbeddedDataSourceTest.closeQuietly(connection);
            throw throwable;
        }
        H2EmbeddedDataSourceTest.closeQuietly(resultSet);
        H2EmbeddedDataSourceTest.closeQuietly(statement);
        H2EmbeddedDataSourceTest.closeQuietly(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitFromFile() throws Exception {
        File initScript = File.createTempFile("initscript", ".ddl");
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            URL url = Resources.getResource((String)"io/airlift/dbpool/h2.ddl");
            Resources.asByteSource((URL)url).copyTo(Files.asByteSink((File)initScript, (FileWriteMode[])new FileWriteMode[0]));
            H2EmbeddedDataSourceConfig config = new H2EmbeddedDataSourceConfig().setFilename(this.file.getAbsolutePath()).setInitScript(initScript.getAbsolutePath()).setCipher(H2EmbeddedDataSourceConfig.Cipher.AES).setFilePassword("filePassword");
            H2EmbeddedDataSource dataSource = new H2EmbeddedDataSource(config);
            connection = dataSource.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select * from message");
            initScript.delete();
        }
        catch (Throwable throwable) {
            initScript.delete();
            H2EmbeddedDataSourceTest.closeQuietly(resultSet);
            H2EmbeddedDataSourceTest.closeQuietly(statement);
            H2EmbeddedDataSourceTest.closeQuietly(connection);
            throw throwable;
        }
        H2EmbeddedDataSourceTest.closeQuietly(resultSet);
        H2EmbeddedDataSourceTest.closeQuietly(statement);
        H2EmbeddedDataSourceTest.closeQuietly(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={JdbcSQLSyntaxErrorException.class})
    public void testInitFromInvalidDdlThrows() throws Exception {
        File initScript = File.createTempFile("initscript", ".ddl");
        try {
            String invalidDdl = "This isn't valid SQL";
            Files.asCharSink((File)initScript, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)invalidDdl);
            H2EmbeddedDataSourceConfig config = new H2EmbeddedDataSourceConfig().setFilename(this.file.getAbsolutePath()).setInitScript(initScript.getAbsolutePath()).setCipher(H2EmbeddedDataSourceConfig.Cipher.AES).setFilePassword("filePassword");
            new H2EmbeddedDataSource(config);
        }
        finally {
            initScript.delete();
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullFilenameThrows() throws Exception {
        H2EmbeddedDataSourceConfig config = new H2EmbeddedDataSourceConfig().setInitScript("io/airlift/dbpool/h2.ddl").setCipher(H2EmbeddedDataSourceConfig.Cipher.AES).setFilePassword("filePassword");
        new H2EmbeddedDataSource(config);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testEmptyFilenameThrows() throws Exception {
        H2EmbeddedDataSourceConfig config = new H2EmbeddedDataSourceConfig().setFilename("").setInitScript("io/airlift/dbpool/h2.ddl").setCipher(H2EmbeddedDataSourceConfig.Cipher.AES).setFilePassword("filePassword");
        new H2EmbeddedDataSource(config);
    }

    @Test(expectedExceptions={FileNotFoundException.class})
    public void testCantFindInitScript() throws Exception {
        H2EmbeddedDataSourceConfig config = new H2EmbeddedDataSourceConfig().setFilename(this.file.getAbsolutePath()).setInitScript("foo").setCipher(H2EmbeddedDataSourceConfig.Cipher.AES).setFilePassword("filePassword");
        new H2EmbeddedDataSource(config);
    }

    private static void closeQuietly(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void closeQuietly(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void closeQuietly(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

