/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.dbpool;

import io.airlift.dbpool.ManagedDataSource;
import io.airlift.dbpool.MockConnectionPoolDataSource;
import io.airlift.dbpool.MockManagedDataSource;
import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ManagedDataSourceTest {
    @Test
    public void testBasic() throws Exception {
        MockManagedDataSource dataSource = new MockManagedDataSource(1, new Duration(10.0, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)0L);
        Assert.assertEquals((Object)dataSource.getStats().getCheckout().getAllTime().getCount(), (Object)0.0);
        Assert.assertEquals((Object)dataSource.getStats().getCreate().getAllTime().getCount(), (Object)0.0);
        Assert.assertEquals((Object)dataSource.getStats().getHeld().getAllTime().getCount(), (Object)0.0);
        Assert.assertEquals((long)dataSource.getStats().getConnectionErrorCount(), (long)0L);
        Connection connection = dataSource.getConnection();
        Assert.assertNotNull((Object)connection);
        Assert.assertTrue((boolean)(connection instanceof MockConnectionPoolDataSource.MockConnection));
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)1L);
        Assert.assertEquals((Object)dataSource.getStats().getCheckout().getAllTime().getCount(), (Object)1.0);
        Assert.assertEquals((Object)dataSource.getStats().getCreate().getAllTime().getCount(), (Object)1.0);
        Assert.assertEquals((Object)dataSource.getStats().getHeld().getAllTime().getCount(), (Object)0.0);
        Assert.assertEquals((long)dataSource.getStats().getConnectionErrorCount(), (long)0L);
        connection.close();
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)0L);
        Assert.assertEquals((Object)dataSource.getStats().getCheckout().getAllTime().getCount(), (Object)1.0);
        Assert.assertEquals((Object)dataSource.getStats().getCreate().getAllTime().getCount(), (Object)1.0);
        Assert.assertEquals((Object)dataSource.getStats().getHeld().getAllTime().getCount(), (Object)1.0);
        Assert.assertEquals((long)dataSource.getStats().getConnectionErrorCount(), (long)0L);
    }

    @Test
    public void testMaxConnectionWaitMillis() throws Exception {
        MockManagedDataSource dataSource = new MockManagedDataSource(1, new Duration(10.0, TimeUnit.MILLISECONDS));
        Assert.assertEquals((int)dataSource.getMaxConnectionWaitMillis(), (int)10);
        Connection connection = dataSource.getConnection();
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)1L);
        long start = System.nanoTime();
        try {
            dataSource.getConnection();
            Assert.fail((String)"Expected SQLException from timeout");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Duration duration = Duration.nanosSince((long)start);
        Assertions.assertGreaterThan((Comparable)duration, (Comparable)new Duration(10.0, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)1L);
        dataSource.setMaxConnectionWaitMillis(new Duration(50.0, TimeUnit.MILLISECONDS));
        Assert.assertEquals((int)dataSource.getMaxConnectionWaitMillis(), (int)50);
        start = System.nanoTime();
        try {
            dataSource.getConnection();
            Assert.fail((String)"Expected SQLException from timeout");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        duration = Duration.nanosSince((long)start);
        Assertions.assertGreaterThan((Comparable)duration, (Comparable)new Duration(50.0, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)1L);
        try {
            dataSource.setMaxConnectionWaitMillis(null);
            Assert.fail((String)"NullPointerException IllegalArgumentException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((int)dataSource.getMaxConnectionWaitMillis(), (int)50);
        try {
            dataSource.setMaxConnectionWaitMillis(new Duration(0.0, TimeUnit.MILLISECONDS));
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)dataSource.getMaxConnectionWaitMillis(), (int)50);
        connection.close();
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)0L);
    }

    @Test
    public void testMaxConnections() throws Exception {
        MockManagedDataSource dataSource = new MockManagedDataSource(1, new Duration(1.0, TimeUnit.MILLISECONDS));
        Assert.assertEquals((int)dataSource.getMaxConnections(), (int)1);
        LinkedList<Connection> connections = new LinkedList<Connection>();
        connections.add(dataSource.getConnection());
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)1L);
        try {
            dataSource.getConnection();
            Assert.fail((String)"Expected SQLException from timeout");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)1L);
        dataSource.setMaxConnections(3);
        Assert.assertEquals((int)dataSource.getMaxConnections(), (int)3);
        connections.add(dataSource.getConnection());
        connections.add(dataSource.getConnection());
        try {
            dataSource.getConnection();
            Assert.fail((String)"Expected SQLException from timeout");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)3L);
        dataSource.setMaxConnections(2);
        Assert.assertEquals((int)dataSource.getMaxConnections(), (int)2);
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)3L);
        try {
            dataSource.getConnection();
            Assert.fail((String)"Expected SQLException from timeout");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)3L);
        ((Connection)connections.remove()).close();
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)2L);
        try {
            dataSource.getConnection();
            Assert.fail((String)"Expected SQLException from timeout");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)2L);
        ((Connection)connections.remove()).close();
        connections.add(dataSource.getConnection());
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)2L);
        try {
            dataSource.setMaxConnectionWaitMillis(null);
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((int)dataSource.getMaxConnections(), (int)2);
        try {
            dataSource.setMaxConnectionWaitMillis(new Duration(0.0, TimeUnit.MILLISECONDS));
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)dataSource.getMaxConnections(), (int)2);
        for (Connection connection : connections) {
            connection.close();
        }
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)0L);
    }

    @Test
    public void testAcquirePermitInterrupted() throws Exception {
        final MockManagedDataSource dataSource = new MockManagedDataSource(1, new Duration(5000.0, TimeUnit.MILLISECONDS));
        Assert.assertEquals((int)dataSource.getMaxConnectionWaitMillis(), (int)5000);
        Connection connection = dataSource.getConnection();
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)1L);
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch endLatch = new CountDownLatch(1);
        final AtomicBoolean wasInterrupted = new AtomicBoolean();
        final AtomicReference exception = new AtomicReference();
        Thread createThread = new Thread(){

            @Override
            public void run() {
                startLatch.countDown();
                try {
                    dataSource.getConnection();
                }
                catch (SQLException e) {
                    exception.set(e);
                }
                finally {
                    wasInterrupted.set(this.isInterrupted());
                    endLatch.countDown();
                }
            }
        };
        createThread.start();
        startLatch.await();
        createThread.interrupt();
        endLatch.await();
        Assert.assertTrue((boolean)wasInterrupted.get(), (String)"createThread.isInterrupted()");
        SQLException sqlException = (SQLException)exception.get();
        Assert.assertNotNull((Object)sqlException);
        Assertions.assertInstanceOf((Object)sqlException.getCause(), InterruptedException.class);
        connection.close();
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)0L);
    }

    @Test
    public void testIdempotentClose() throws Exception {
        MockManagedDataSource dataSource = new MockManagedDataSource(10, new Duration(10.0, TimeUnit.MILLISECONDS));
        ArrayList<MockConnectionPoolDataSource.MockConnection> connections = new ArrayList<MockConnectionPoolDataSource.MockConnection>();
        for (int i = 0; i < 10; ++i) {
            MockConnectionPoolDataSource.MockConnection connection = (MockConnectionPoolDataSource.MockConnection)dataSource.getConnection();
            Assert.assertNotNull((Object)connection);
            connections.add(connection);
        }
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)10L);
        Collections.shuffle(connections);
        int closedCount = 0;
        for (MockConnectionPoolDataSource.MockConnection connection : connections) {
            ++closedCount;
            for (int j = 0; j < 7; ++j) {
                connection.close();
                Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)(10 - closedCount));
            }
        }
    }

    @Test
    public void testConnectionException() throws Exception {
        MockManagedDataSource dataSource = new MockManagedDataSource(1, new Duration(10.0, TimeUnit.MILLISECONDS));
        MockConnectionPoolDataSource.MockConnection connection = (MockConnectionPoolDataSource.MockConnection)dataSource.getConnection();
        Assert.assertNotNull((Object)connection);
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)1L);
        connection.errorOccurred();
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)0L);
    }

    @Test
    public void testCreateException() {
        MockConnectionPoolDataSource mockConnectionPoolDataSource = new MockConnectionPoolDataSource();
        MockManagedDataSource dataSource = new MockManagedDataSource(mockConnectionPoolDataSource, 1, new Duration(10.0, TimeUnit.MILLISECONDS));
        mockConnectionPoolDataSource.createException = new SQLException();
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)0L);
        try {
            dataSource.getConnection();
            Assert.fail((String)"expected SQLException");
        }
        catch (SQLException e) {
            Assert.assertSame((Object)e, (Object)mockConnectionPoolDataSource.createException);
        }
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)0L);
    }

    @Test
    public void testCloseException() throws SQLException {
        MockConnectionPoolDataSource mockConnectionPoolDataSource = new MockConnectionPoolDataSource();
        MockManagedDataSource dataSource = new MockManagedDataSource(1, new Duration(10.0, TimeUnit.MILLISECONDS));
        mockConnectionPoolDataSource.closeException = new SQLException();
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)0L);
        MockConnectionPoolDataSource.MockConnection connection = (MockConnectionPoolDataSource.MockConnection)dataSource.getConnection();
        Assert.assertNotNull((Object)connection);
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)1L);
        connection.close();
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)0L);
        connection = (MockConnectionPoolDataSource.MockConnection)dataSource.getConnection();
        Assert.assertNotNull((Object)connection);
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)1L);
        connection.close();
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)0L);
        connection.errorOccurred();
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)0L);
    }

    @Test
    public void testIdempotentCloseAndException() throws SQLException {
        MockConnectionPoolDataSource mockConnectionPoolDataSource = new MockConnectionPoolDataSource();
        MockManagedDataSource dataSource = new MockManagedDataSource(1, new Duration(10.0, TimeUnit.MILLISECONDS));
        mockConnectionPoolDataSource.closeException = new SQLException();
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)0L);
        MockConnectionPoolDataSource.MockConnection connection = (MockConnectionPoolDataSource.MockConnection)dataSource.getConnection();
        Assert.assertNotNull((Object)connection);
        Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)1L);
        for (int i = 0; i < 10; ++i) {
            connection.close();
            Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)0L);
            connection.errorOccurred();
            Assert.assertEquals((long)dataSource.getConnectionsActive(), (long)0L);
        }
    }

    @Test
    public void testLogWriterIsNeverSet() throws SQLException {
        PrintWriter expectedLogWriter;
        MockConnectionPoolDataSource mockConnectionPoolDataSource = new MockConnectionPoolDataSource();
        mockConnectionPoolDataSource.logWriter = expectedLogWriter = new PrintWriter(new StringWriter());
        MockManagedDataSource dataSource = new MockManagedDataSource(mockConnectionPoolDataSource, 1, new Duration(10.0, TimeUnit.MILLISECONDS));
        Assert.assertNull((Object)dataSource.getLogWriter());
        PrintWriter newWriter = new PrintWriter(new StringWriter());
        dataSource.setLogWriter(newWriter);
        Assert.assertNull((Object)dataSource.getLogWriter());
        Assert.assertSame((Object)mockConnectionPoolDataSource.logWriter, (Object)expectedLogWriter);
    }

    @Test
    public void testLoginTimeoutIsNeverSet() throws SQLException {
        MockConnectionPoolDataSource mockConnectionPoolDataSource = new MockConnectionPoolDataSource();
        mockConnectionPoolDataSource.loginTimeout = 42;
        MockManagedDataSource dataSource = new MockManagedDataSource(mockConnectionPoolDataSource, 1, new Duration(5.0, TimeUnit.SECONDS));
        Assert.assertEquals((int)dataSource.getLoginTimeout(), (int)5);
        int newTimeout = 12345;
        dataSource.setLoginTimeout(newTimeout);
        Assert.assertEquals((int)dataSource.getLoginTimeout(), (int)5);
        Assert.assertEquals((int)mockConnectionPoolDataSource.loginTimeout, (int)42);
    }

    @Test
    public void testWrapper() throws SQLException {
        MockManagedDataSource dataSource = new MockManagedDataSource(1, new Duration(10.0, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)dataSource.isWrapperFor(ManagedDataSource.class));
        Assert.assertTrue((boolean)dataSource.isWrapperFor(DataSource.class));
        Assert.assertTrue((boolean)dataSource.isWrapperFor(Object.class));
        Assert.assertFalse((boolean)dataSource.isWrapperFor(ConnectionPoolDataSource.class));
        Assert.assertFalse((boolean)dataSource.isWrapperFor(Integer.class));
        try {
            dataSource.isWrapperFor(null);
            Assert.fail((String)"Expected SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            dataSource.unwrap(null);
            Assert.fail((String)"Expected SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertSame((Object)dataSource.unwrap(ManagedDataSource.class), (Object)((Object)dataSource));
        Assert.assertSame((Object)dataSource.unwrap(DataSource.class), (Object)((Object)dataSource));
        Assert.assertSame((Object)dataSource.unwrap(Object.class), (Object)((Object)dataSource));
        try {
            dataSource.unwrap(ConnectionPoolDataSource.class);
            Assert.fail((String)"Expected SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            dataSource.unwrap(Integer.class);
            Assert.fail((String)"Expected SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testGetConnectionUsernamePassword() throws SQLException {
        MockManagedDataSource dataSource = new MockManagedDataSource(1, new Duration(10.0, TimeUnit.MILLISECONDS));
        try {
            dataSource.getConnection("username", "password");
            Assert.fail((String)"Expected SQLException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

