/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.dbpool;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.dbpool.H2EmbeddedDataSourceConfig;
import io.airlift.testing.ValidationAssertions;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.testng.annotations.Test;

public class TestH2EmbeddedDataSourceConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((H2EmbeddedDataSourceConfig)((H2EmbeddedDataSourceConfig)((H2EmbeddedDataSourceConfig)ConfigAssertions.recordDefaults(H2EmbeddedDataSourceConfig.class)).setAllowLiterals(H2EmbeddedDataSourceConfig.AllowLiterals.ALL).setCacheSize(16384).setCipher(H2EmbeddedDataSourceConfig.Cipher.NONE).setCompressLob(H2EmbeddedDataSourceConfig.CompressLob.LZF).setFilename(null).setFilePassword(null).setInitScript(null).setMaxLengthInplaceLob(1024L).setMaxMemoryRows(10000L).setMaxConnections(10)).setMaxConnectionWait(new Duration(500.0, TimeUnit.MILLISECONDS))));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"db.allow-literals", (Object)"NONE").put((Object)"db.cache-size", (Object)"4096").put((Object)"db.cipher", (Object)"AES").put((Object)"db.compress-lob", (Object)"NO").put((Object)"db.filename", (Object)"TestData").put((Object)"db.file-password", (Object)"test123").put((Object)"db.init-script", (Object)"init.sql").put((Object)"db.inplace.lob.length.max", (Object)"8192").put((Object)"db.rows.memory.max", (Object)"5000").put((Object)"db.connections.max", (Object)"12").put((Object)"db.connections.wait", (Object)"42s").build();
        H2EmbeddedDataSourceConfig expected = (H2EmbeddedDataSourceConfig)((H2EmbeddedDataSourceConfig)new H2EmbeddedDataSourceConfig().setAllowLiterals(H2EmbeddedDataSourceConfig.AllowLiterals.NONE).setCacheSize(4096).setCipher(H2EmbeddedDataSourceConfig.Cipher.AES).setCompressLob(H2EmbeddedDataSourceConfig.CompressLob.NO).setFilename("TestData").setFilePassword("test123").setInitScript("init.sql").setMaxLengthInplaceLob(8192L).setMaxMemoryRows(5000L).setMaxConnections(12)).setMaxConnectionWait(new Duration(42.0, TimeUnit.SECONDS));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testValidations() {
        ValidationAssertions.assertFailsValidation((Object)new H2EmbeddedDataSourceConfig(), (String)"filename", (String)"may not be null", NotNull.class);
    }
}

